/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.stats;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.plugins.views.search.views.DashboardService;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alerts.AlertService;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.inputs.InputService;
import org.graylog2.shared.users.UserService;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.graylog2.system.stats.AlarmStats;
import org.graylog2.system.stats.ClusterStats;
import org.graylog2.system.stats.elasticsearch.ElasticsearchStats;
import org.graylog2.system.stats.mongo.MongoProbe;
import org.graylog2.system.stats.mongo.MongoStats;
import org.graylog2.users.RoleService;

@Singleton
public class ClusterStatsService {
    private final MongoProbe mongoProbe;
    private final UserService userService;
    private final InputService inputService;
    private final StreamService streamService;
    private final StreamRuleService streamRuleService;
    private final OutputService outputService;
    private final RoleService roleService;
    private final AlertService alertService;
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final DashboardService dashboardService;
    private final Cluster cluster;

    @Inject
    public ClusterStatsService(MongoProbe mongoProbe, UserService userService, InputService inputService, StreamService streamService, StreamRuleService streamRuleService, OutputService outputService, RoleService roleService, AlertService alertService, AlarmCallbackConfigurationService alarmCallbackConfigurationService, DashboardService dashboardService, Cluster cluster) {
        this.mongoProbe = mongoProbe;
        this.userService = userService;
        this.inputService = inputService;
        this.streamService = streamService;
        this.streamRuleService = streamRuleService;
        this.outputService = outputService;
        this.roleService = roleService;
        this.alertService = alertService;
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.dashboardService = dashboardService;
        this.cluster = cluster;
    }

    public ClusterStats clusterStats() {
        return ClusterStats.create(this.elasticsearchStats(), this.mongoStats(), this.streamService.count(), this.streamRuleService.totalStreamRuleCount(), this.streamRuleService.streamRuleCountByStream(), this.userService.count(), this.outputService.count(), this.outputService.countByType(), this.countDashboards(), this.inputService.totalCount(), this.inputService.globalCount(), this.inputService.totalCountByType(), this.inputService.totalExtractorCount(), this.inputService.totalExtractorCountByType(), this.alarmStats());
    }

    private long countDashboards() {
        return this.dashboardService.count();
    }

    public ElasticsearchStats elasticsearchStats() {
        return this.cluster.elasticsearchStats();
    }

    public MongoStats mongoStats() {
        return this.mongoProbe.mongoStats();
    }

    public AlarmStats alarmStats() {
        long totalCount = this.alertService.totalCount();
        Map<String, Long> counterPerType = this.alarmCallbackConfigurationService.countPerType();
        return AlarmStats.create(totalCount, counterPerType);
    }
}

