/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.bson.types.ObjectId;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.security.PermissionAndRoleResolver;
import org.graylog.security.permissions.GRNPermission;
import org.graylog2.Configuration;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.AccessTokenService;
import org.graylog2.security.InMemoryRolePermissionResolver;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.Roles;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleService;
import org.graylog2.users.UserImpl;
import org.graylog2.users.events.UserChangedEvent;
import org.graylog2.users.events.UserDeletedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServiceImpl
extends PersistedServiceImpl
implements UserService {
    private static final Logger LOG = LoggerFactory.getLogger(UserServiceImpl.class);
    private final Configuration configuration;
    private final RoleService roleService;
    private final AccessTokenService accesstokenService;
    private final UserImpl.Factory userFactory;
    private final InMemoryRolePermissionResolver inMemoryRolePermissionResolver;
    private final EventBus serverEventBus;
    private final GRNRegistry grnRegistry;
    private final PermissionAndRoleResolver permissionAndRoleResolver;

    @Inject
    public UserServiceImpl(MongoConnection mongoConnection, Configuration configuration, RoleService roleService, AccessTokenService accessTokenService, UserImpl.Factory userFactory, InMemoryRolePermissionResolver inMemoryRolePermissionResolver, EventBus serverEventBus, GRNRegistry grnRegistry, PermissionAndRoleResolver permissionAndRoleResolver) {
        super(mongoConnection);
        this.configuration = configuration;
        this.roleService = roleService;
        this.accesstokenService = accessTokenService;
        this.userFactory = userFactory;
        this.inMemoryRolePermissionResolver = inMemoryRolePermissionResolver;
        this.serverEventBus = serverEventBus;
        this.grnRegistry = grnRegistry;
        this.permissionAndRoleResolver = permissionAndRoleResolver;
        this.collection(UserImpl.class).createIndex("roles");
    }

    @Override
    @Nullable
    public User loadById(String id) {
        if (!this.configuration.isRootUserDisabled() && id.equals("local:admin")) {
            LOG.debug("User {} is the built-in admin user", (Object)id);
            return this.userFactory.createLocalAdminUser(this.roleService.getAdminRoleObjectId());
        }
        DBObject userObject = this.get(UserImpl.class, id);
        if (userObject == null) {
            return null;
        }
        Object userId = userObject.get("_id");
        return this.userFactory.create((ObjectId)userId, userObject.toMap());
    }

    @Override
    public List<User> loadByIds(Collection<String> ids) {
        HashSet<String> userIds = new HashSet<String>(ids);
        ArrayList<User> users = new ArrayList<User>();
        if (!this.configuration.isRootUserDisabled() && userIds.stream().anyMatch("local:admin"::equals)) {
            userIds.remove("local:admin");
            users.add(this.userFactory.createLocalAdminUser(this.roleService.getAdminRoleObjectId()));
        }
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)new BasicDBObject("$in", userIds.stream().map(ObjectId::new).collect(Collectors.toSet())));
        List<DBObject> result = this.query(UserImpl.class, (DBObject)query);
        if (result == null || result.isEmpty()) {
            return users;
        }
        for (DBObject dbObject : result) {
            users.add(this.userFactory.create((ObjectId)dbObject.get("_id"), dbObject.toMap()));
        }
        return users;
    }

    @Override
    @Nullable
    public User load(String username) {
        LOG.debug("Loading user {}", (Object)username);
        if (!this.configuration.isRootUserDisabled() && this.configuration.getRootUsername().equals(username)) {
            LOG.debug("User {} is the built-in admin user", (Object)username);
            return this.userFactory.createLocalAdminUser(this.roleService.getAdminRoleObjectId());
        }
        BasicDBObject query = new BasicDBObject();
        query.put("username", (Object)username);
        List<DBObject> result = this.query(UserImpl.class, (DBObject)query);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            String msg = "There was more than one matching user for username " + username + ". This should never happen.";
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
        DBObject userObject = result.get(0);
        Object userId = userObject.get("_id");
        LOG.debug("Loaded user {}/{} from MongoDB", (Object)username, userId);
        return this.userFactory.create((ObjectId)userId, userObject.toMap());
    }

    @Override
    public Optional<User> loadByAuthServiceUidOrUsername(String authServiceUid, String username) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)authServiceUid) ? 1 : 0) != 0, (Object)"authServiceUid cannot be blank");
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)username) ? 1 : 0) != 0, (Object)"username cannot be blank");
        LOG.debug("Loading user by auth service UID <{}> or username <{}>", (Object)authServiceUid, (Object)username);
        if (!this.configuration.isRootUserDisabled() && this.configuration.getRootUsername().equals(username)) {
            LOG.debug("User <{}> is the built-in admin user", (Object)username);
            return Optional.ofNullable(this.userFactory.createLocalAdminUser(this.roleService.getAdminRoleObjectId()));
        }
        BasicDBObject query = new BasicDBObject("$or", (Object)ImmutableList.of((Object)new BasicDBObject("auth_service_uid", (Object)authServiceUid), (Object)new BasicDBObject("username", (Object)username)));
        List<DBObject> result = this.query(UserImpl.class, (DBObject)query);
        if (result == null || result.isEmpty()) {
            return Optional.empty();
        }
        if (result.size() > 1) {
            String msg = "There was more than one matching user for auth service UID <" + authServiceUid + "> or username <" + username + ">. This should never happen.";
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
        DBObject userObject = result.get(0);
        Object userId = userObject.get("_id");
        LOG.debug("Loaded user {}/{}/{} from MongoDB", new Object[]{authServiceUid, username, userId});
        return Optional.ofNullable(this.userFactory.create((ObjectId)userId, userObject.toMap()));
    }

    @Override
    public int delete(String username) {
        BasicDBObject query = new BasicDBObject();
        query.put("username", (Object)username);
        List<DBObject> result = this.query(UserImpl.class, (DBObject)query);
        if (result == null || result.isEmpty()) {
            return 0;
        }
        ImmutableList.Builder deletedUsers = ImmutableList.builder();
        result.forEach(userObject -> {
            ObjectId userId = (ObjectId)userObject.get("_id");
            deletedUsers.add((Object)UserDeletedEvent.create(userId.toHexString(), username));
        });
        LOG.debug("Deleting user(s) with username \"{}\"", (Object)username);
        query = BasicDBObjectBuilder.start((String)"username", (Object)username).get();
        int deleteCount = this.destroy((DBObject)query, "users");
        if (deleteCount > 1) {
            LOG.warn("Removed {} users matching username \"{}\".", (Object)deleteCount, (Object)username);
        }
        this.accesstokenService.deleteAllForUser(username);
        deletedUsers.build().forEach(arg_0 -> ((EventBus)this.serverEventBus).post(arg_0));
        return deleteCount;
    }

    @Override
    public int deleteById(String userId) {
        User user = this.loadById(userId);
        if (user == null) {
            return 0;
        }
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)new ObjectId(userId));
        int deleteCount = this.destroy((DBObject)query, "users");
        this.accesstokenService.deleteAllForUser(user.getName());
        this.serverEventBus.post((Object)UserDeletedEvent.create(userId, user.getName()));
        return deleteCount;
    }

    @Override
    public User create() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("auth_service_id", null);
        fields.put("auth_service_uid", null);
        fields.put("external_user", false);
        return this.userFactory.create(fields);
    }

    @Override
    public List<User> loadAll() {
        BasicDBObject query = new BasicDBObject();
        List<DBObject> result = this.query(UserImpl.class, (DBObject)query);
        ArrayList users = Lists.newArrayList();
        for (DBObject dbObject : result) {
            users.add(this.userFactory.create((ObjectId)dbObject.get("_id"), dbObject.toMap()));
        }
        return users;
    }

    @Override
    public <T extends Persisted> String save(T model) throws ValidationException {
        if (model instanceof UserImpl.LocalAdminUser) {
            throw new IllegalStateException("Cannot modify local root user, this is a bug.");
        }
        String userId = super.save(model);
        this.serverEventBus.post((Object)UserChangedEvent.create(userId));
        return userId;
    }

    @Override
    @Deprecated
    public User getAdminUser() {
        return this.getRootUser().orElseThrow(() -> new IllegalStateException("Local admin user requested but root user is disabled in config."));
    }

    @Override
    public Optional<User> getRootUser() {
        if (this.configuration.isRootUserDisabled()) {
            return Optional.empty();
        }
        return Optional.of(this.userFactory.createLocalAdminUser(this.roleService.getAdminRoleObjectId()));
    }

    @Override
    public long count() {
        return this.totalCount(UserImpl.class);
    }

    @Override
    public List<User> loadAllForAuthServiceBackend(String authServiceBackendId) {
        DBObject query = BasicDBObjectBuilder.start((String)"auth_service_id", (Object)authServiceBackendId).get();
        List<DBObject> result = this.query(UserImpl.class, query);
        ArrayList users = Lists.newArrayList();
        for (DBObject dbObject : result) {
            users.add(this.userFactory.create((ObjectId)dbObject.get("_id"), dbObject.toMap()));
        }
        return users;
    }

    @Override
    public Collection<User> loadAllForRole(Role role) {
        String roleId = role.getId();
        DBObject query = BasicDBObjectBuilder.start((String)"roles", (Object)new ObjectId(roleId)).get();
        List<DBObject> result = this.query(UserImpl.class, query);
        if (result == null || result.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet users = Sets.newHashSetWithExpectedSize((int)result.size());
        for (DBObject dbObject : result) {
            users.add(this.userFactory.create((ObjectId)dbObject.get("_id"), dbObject.toMap()));
        }
        return users;
    }

    @Override
    public Set<String> getRoleNames(User user) {
        Map<String, Role> idMap;
        Set<String> roleIds = user.getRoleIds();
        if (roleIds.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            idMap = this.roleService.loadAllIdMap();
        }
        catch (NotFoundException e) {
            LOG.error("Unable to load role ID map. Using empty map.", (Throwable)e);
            idMap = Collections.emptyMap();
        }
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Collections2.transform(roleIds, (Function)Roles.roleIdToNameFunction(idMap)), (Predicate)Predicates.notNull()));
    }

    @Override
    public List<Permission> getPermissionsForUser(User user) {
        GRN principal = this.grnRegistry.ofUser(user);
        ImmutableSet.Builder permSet = ImmutableSet.builder().addAll((Iterable)user.getPermissions().stream().map(WildcardPermission::new).collect(Collectors.toSet())).addAll(this.permissionAndRoleResolver.resolvePermissionsForPrincipal(principal)).addAll((Iterable)this.getUserPermissionsFromRoles(user).stream().map(WildcardPermission::new).collect(Collectors.toSet()));
        return permSet.build().asList();
    }

    @Override
    public List<WildcardPermission> getWildcardPermissionsForUser(User user) {
        return this.getPermissionsForUser(user).stream().filter(WildcardPermission.class::isInstance).map(WildcardPermission.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<GRNPermission> getGRNPermissionsForUser(User user) {
        return this.getPermissionsForUser(user).stream().filter(GRNPermission.class::isInstance).map(GRNPermission.class::cast).collect(Collectors.toList());
    }

    @Override
    public Set<String> getUserPermissionsFromRoles(User user) {
        ImmutableSet.Builder permSet = ImmutableSet.builder();
        for (String roleId2 : user.getRoleIds()) {
            permSet.addAll(this.inMemoryRolePermissionResolver.resolveStringPermission(roleId2));
        }
        this.permissionAndRoleResolver.resolveRolesForPrincipal(this.grnRegistry.ofUser(user)).forEach(roleId -> permSet.addAll(this.inMemoryRolePermissionResolver.resolveStringPermission((String)roleId)));
        return permSet.build();
    }

    @Override
    public void dissociateAllUsersFromRole(Role role) {
        Collection<User> usersInRole = this.loadAllForRole(role);
        for (User user : usersInRole) {
            if (user.isLocalAdmin()) continue;
            HashSet roles = Sets.newHashSet(user.getRoleIds());
            roles.remove(role.getId());
            user.setRoleIds(roles);
            try {
                this.save(user);
            }
            catch (ValidationException e) {
                LOG.error("Unable to remove role {} from user {}", (Object)role.getName(), (Object)user);
            }
        }
    }
}

