/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.hibernate;

import java.util.Set;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheTx;
import org.gridgain.grid.cache.GridCacheTxConcurrency;
import org.gridgain.grid.cache.GridCacheTxIsolation;
import org.gridgain.grid.cache.hibernate.GridHibernateAccessStrategyAdapter;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.util.GridLeanSet;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;

public class GridHibernateReadWriteAccessStrategy
extends GridHibernateAccessStrategyAdapter {
    private final ThreadLocal<TxContext> txCtx;

    protected GridHibernateReadWriteAccessStrategy(Grid grid, GridCache<Object, Object> cache, ThreadLocal txCtx) {
        super(grid, cache);
        this.txCtx = txCtx;
    }

    @Override
    protected Object get(Object key) throws CacheException {
        try {
            return this.cache.get(key);
        }
        catch (GridException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void putFromLoad(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new GridPredicate[0]);
        }
        catch (GridException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected SoftLock lock(Object key) throws CacheException {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx == null) {
                ctx = new TxContext();
                this.txCtx.set(ctx);
            }
            this.lockKey(key);
            ctx.locked(key);
            return null;
        }
        catch (GridException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void unlock(Object key, SoftLock lock) throws CacheException {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.unlock(ctx, key);
            }
        }
        catch (GridException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected boolean update(Object key, Object val) throws CacheException {
        return false;
    }

    @Override
    protected boolean afterUpdate(Object key, Object val, SoftLock lock) throws CacheException {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.cache.putx(key, val, new GridPredicate[0]);
                this.unlock(ctx, key);
                return true;
            }
            return false;
        }
        catch (GridException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected boolean insert(Object key, Object val) throws CacheException {
        return false;
    }

    @Override
    protected boolean afterInsert(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new GridPredicate[0]);
            return true;
        }
        catch (GridException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void remove(Object key) throws CacheException {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.cache.removex(key, new GridPredicate[0]);
            }
        }
        catch (GridException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(TxContext ctx, Object key) throws GridException {
        if (ctx.unlocked(key)) {
            this.txCtx.remove();
            GridCacheTx tx = this.cache.tx();
            assert (tx != null);
            try {
                tx.commit();
            }
            finally {
                tx.close();
            }
            assert (this.cache.tx() == null);
        }
    }

    private void rollbackCurrentTx() {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.txCtx.remove();
                GridCacheTx tx = this.cache.tx();
                if (tx != null) {
                    tx.rollback();
                }
            }
        }
        catch (GridException e) {
            this.log.error("Failed to rollback cache transaction.", (Throwable)e);
        }
    }

    private void lockKey(Object key) throws GridException {
        if (this.cache.tx() == null) {
            this.cache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);
        }
        this.cache.get(key);
    }

    private static class TxContext {
        private Set<Object> locked = new GridLeanSet();

        private TxContext() {
        }

        void locked(Object key) {
            this.locked.add(key);
        }

        boolean unlocked(Object key) {
            this.locked.remove(key);
            return this.locked.isEmpty();
        }
    }
}

