/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.store.hibernate;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCacheTx;
import org.gridgain.grid.cache.store.GridCacheStoreAdapter;
import org.gridgain.grid.cache.store.hibernate.GridCacheHibernateBlobStoreEntry;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.marshaller.GridMarshaller;
import org.gridgain.grid.resources.GridLoggerResource;
import org.gridgain.grid.resources.GridMarshallerResource;
import org.gridgain.grid.util.tostring.GridToStringExclude;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.jetbrains.annotations.Nullable;

public class GridCacheHibernateBlobStore<K, V>
extends GridCacheStoreAdapter<K, V> {
    public static final String DFLT_CONN_URL = "jdbc:h2:mem:hibernateCacheStore;DB_CLOSE_DELAY=-1;DEFAULT_LOCK_TIMEOUT=5000";
    public static final String DFLT_SHOW_SQL = "true";
    public static final String DFLT_HBM2DDL_AUTO = "update";
    private static final String ATTR_SES = "HIBERNATE_STORE_SESSION";
    private static final String MAPPING_RESOURCE = "org/gridgain/grid/cache/store/hibernate/GridCacheHibernateBlobStoreEntry.hbm.xml";
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);
    @GridToStringExclude
    private Properties hibernateProps;
    @GridToStringExclude
    private SessionFactory sesFactory;
    private String hibernateCfgPath;
    @GridLoggerResource
    private GridLogger log;
    @GridMarshallerResource
    private GridMarshaller marsh;

    public V load(@Nullable GridCacheTx tx, K key) throws GridException {
        this.init();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Store load [key=" + key + ", tx=" + tx + ']');
        }
        Session ses = this.session(tx);
        try {
            GridCacheHibernateBlobStoreEntry entry = (GridCacheHibernateBlobStoreEntry)ses.get(GridCacheHibernateBlobStoreEntry.class, (Serializable)this.toBytes(key));
            if (entry == null) {
                V v = null;
                return v;
            }
            Object x = this.fromBytes(entry.getValue());
            return (V)x;
        }
        catch (HibernateException e) {
            this.rollback((SharedSessionContract)ses, tx);
            throw new GridException("Failed to load value from cache store with key: " + key, (Throwable)e);
        }
        finally {
            this.end(ses, tx);
        }
    }

    public void put(@Nullable GridCacheTx tx, K key, @Nullable V val) throws GridException {
        this.init();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Store put [key=" + key + ", val=" + val + ", tx=" + tx + ']');
        }
        if (val == null) {
            this.remove(tx, key);
            return;
        }
        Session ses = this.session(tx);
        try {
            GridCacheHibernateBlobStoreEntry entry = new GridCacheHibernateBlobStoreEntry(this.toBytes(key), this.toBytes(val));
            ses.saveOrUpdate((Object)entry);
        }
        catch (HibernateException e) {
            this.rollback((SharedSessionContract)ses, tx);
            throw new GridException("Failed to put value to cache store [key=" + key + ", val" + val + "]", (Throwable)e);
        }
        finally {
            this.end(ses, tx);
        }
    }

    public void remove(@Nullable GridCacheTx tx, K key) throws GridException {
        this.init();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Store remove [key=" + key + ", tx=" + tx + ']');
        }
        Session ses = this.session(tx);
        try {
            Object obj = ses.get(GridCacheHibernateBlobStoreEntry.class, (Serializable)this.toBytes(key));
            if (obj != null) {
                ses.delete(obj);
            }
        }
        catch (HibernateException e) {
            this.rollback((SharedSessionContract)ses, tx);
            throw new GridException("Failed to remove value from cache store with key: " + key, (Throwable)e);
        }
        finally {
            this.end(ses, tx);
        }
    }

    private void rollback(SharedSessionContract ses, GridCacheTx tx) {
        Transaction hTx;
        if (tx == null && (hTx = ses.getTransaction()) != null && hTx.isActive()) {
            hTx.rollback();
        }
    }

    private void end(Session ses, GridCacheTx tx) {
        if (tx == null) {
            Transaction hTx = ses.getTransaction();
            if (hTx != null && hTx.isActive()) {
                hTx.commit();
            }
            ses.close();
        }
    }

    public void txEnd(GridCacheTx tx, boolean commit) throws GridException {
        Transaction hTx;
        this.init();
        Session ses = (Session)tx.removeMeta(ATTR_SES);
        if (ses != null && (hTx = ses.getTransaction()) != null) {
            try {
                if (commit) {
                    ses.flush();
                    hTx.commit();
                } else {
                    hTx.rollback();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Transaction ended [xid=" + tx.xid() + ", commit=" + commit + ']');
                }
            }
            catch (HibernateException e) {
                throw new GridException("Failed to end transaction [xid=" + tx.xid() + ", commit=" + commit + ']', (Throwable)e);
            }
            finally {
                ses.close();
            }
        }
    }

    Session session(@Nullable GridCacheTx tx) {
        Session ses;
        if (tx != null) {
            ses = (Session)tx.meta(ATTR_SES);
            if (ses == null) {
                ses = this.sesFactory.openSession();
                ses.beginTransaction();
                tx.addMeta(ATTR_SES, (Object)ses);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Hibernate session open [ses=" + ses + ", tx=" + tx.xid() + "]");
                }
            }
        } else {
            ses = this.sesFactory.openSession();
            ses.beginTransaction();
        }
        return ses;
    }

    public void setSessionFactory(SessionFactory sesFactory) {
        this.sesFactory = sesFactory;
    }

    public void setHibernateConfigurationPath(String hibernateCfgPath) {
        this.hibernateCfgPath = hibernateCfgPath;
    }

    public void setHibernateProperties(Properties hibernateProps) {
        this.hibernateProps = hibernateProps;
    }

    /*
     * Exception decompiling
     */
    private void init() throws GridException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resourceAvailable(String name) {
        InputStream cfgStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (cfgStream == null) {
            this.log.error("Classpath resource not found: " + name);
            return false;
        }
        try {
            cfgStream.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.log.error("Failed to read classpath resource: " + name, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            U.close((Closeable)cfgStream, (GridLogger)this.log);
        }
    }

    public String toString() {
        return S.toString(GridCacheHibernateBlobStore.class, (Object)((Object)this));
    }

    protected byte[] toBytes(Object obj) throws GridException {
        return this.marsh.marshal(obj);
    }

    protected <X> X fromBytes(byte[] bytes) throws GridException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return (X)this.marsh.unmarshal(bytes, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

