/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.hibernate;

import java.util.Map;
import java.util.Set;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.hibernate.GridHibernateAccessStrategyAdapter;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.util.GridLeanMap;
import org.gridgain.grid.util.GridLeanSet;
import org.gridgain.grid.util.typedef.F;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.jetbrains.annotations.Nullable;

public class GridHibernateNonStrictAccessStrategy
extends GridHibernateAccessStrategyAdapter {
    private final ThreadLocal<WriteContext> writeCtx;

    protected GridHibernateNonStrictAccessStrategy(Grid grid, GridCache<Object, Object> cache, ThreadLocal writeCtx) {
        super(grid, cache);
        this.writeCtx = writeCtx;
    }

    @Override
    @Nullable
    protected SoftLock lock(Object key) throws CacheException {
        WriteContext ctx = this.writeCtx.get();
        if (ctx == null) {
            ctx = new WriteContext();
            this.writeCtx.set(ctx);
        }
        ctx.locked(key);
        return null;
    }

    @Override
    protected void unlock(Object key, SoftLock lock) throws CacheException {
        try {
            WriteContext ctx = this.writeCtx.get();
            if (ctx != null && ctx.unlocked(key)) {
                this.writeCtx.remove();
                ctx.updateCache((GridCache<Object, Object>)this.cache);
            }
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected boolean update(Object key, Object val) throws CacheException {
        return false;
    }

    @Override
    protected boolean afterUpdate(Object key, Object val, SoftLock lock) throws CacheException {
        WriteContext ctx = this.writeCtx.get();
        if (ctx != null) {
            ctx.updated(key, val);
            this.unlock(key, lock);
            return true;
        }
        return false;
    }

    @Override
    protected boolean insert(Object key, Object val) throws CacheException {
        return false;
    }

    @Override
    protected boolean afterInsert(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new GridPredicate[0]);
            return true;
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void remove(Object key) throws CacheException {
        WriteContext ctx = this.writeCtx.get();
        if (ctx != null) {
            ctx.removed(key);
        }
    }

    private static class WriteContext {
        private Map<Object, Object> updates;
        private Set<Object> rmvs;
        private Set<Object> locked = new GridLeanSet();

        private WriteContext() {
        }

        void locked(Object key) {
            this.locked.add(key);
        }

        boolean unlocked(Object key) {
            this.locked.remove(key);
            return this.locked.isEmpty();
        }

        void updated(Object key, Object val) {
            if (this.updates == null) {
                this.updates = new GridLeanMap();
            }
            this.updates.put(key, val);
        }

        void removed(Object key) {
            if (this.rmvs == null) {
                this.rmvs = new GridLeanSet();
            }
            this.rmvs.add(key);
        }

        void updateCache(GridCache<Object, Object> cache) throws GridException {
            if (!F.isEmpty(this.rmvs)) {
                cache.removeAll(this.rmvs, new GridPredicate[0]);
            }
            if (!F.isEmpty(this.updates)) {
                cache.putAll(this.updates, new GridPredicate[0]);
            }
        }
    }
}

