/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.hibernate;

import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.hibernate.GridHibernateAccessStrategyAdapter;
import org.gridgain.grid.lang.GridPredicate;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.jetbrains.annotations.Nullable;

public class GridHibernateReadOnlyAccessStrategy
extends GridHibernateAccessStrategyAdapter {
    public GridHibernateReadOnlyAccessStrategy(Grid grid, GridCache<Object, Object> cache) {
        super(grid, cache);
    }

    @Override
    protected boolean insert(Object key, Object val) throws CacheException {
        return false;
    }

    @Override
    protected boolean afterInsert(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new GridPredicate[0]);
            return true;
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    @Nullable
    protected SoftLock lock(Object key) throws CacheException {
        return null;
    }

    @Override
    protected void unlock(Object key, SoftLock lock) throws CacheException {
    }

    @Override
    protected void remove(Object key) throws CacheException {
    }

    @Override
    protected boolean update(Object key, Object val) throws CacheException {
        throw new UnsupportedOperationException("Updates are not supported for read-only access strategy.");
    }

    @Override
    protected boolean afterUpdate(Object key, Object val, SoftLock lock) throws CacheException {
        throw new UnsupportedOperationException("Updates are not supported for read-only access strategy.");
    }
}

