/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.hibernate;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.hibernate.GridHibernateCollectionRegion;
import org.gridgain.grid.cache.hibernate.GridHibernateEntityRegion;
import org.gridgain.grid.cache.hibernate.GridHibernateNaturalIdRegion;
import org.gridgain.grid.cache.hibernate.GridHibernateQueryResultsRegion;
import org.gridgain.grid.cache.hibernate.GridHibernateTimestampsRegion;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.typedef.G;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;
import org.jdk8.backport.ConcurrentHashMap8;

public class GridHibernateRegionFactory
implements RegionFactory {
    private static final long serialVersionUID = 0L;
    public static final String GRID_NAME_PROPERTY = "org.gridgain.hibernate.grid_name";
    public static final String DFLT_CACHE_NAME_PROPERTY = "org.gridgain.hibernate.default_cache";
    public static final String REGION_CACHE_PROPERTY = "org.gridgain.hibernate.region_cache.";
    public static final String DFLT_ACCESS_TYPE_PROPERTY = "org.gridgain.hibernate.default_access_type";
    public static final String GRID_CONFIG_PROPERTY = "org.gridgain.hibernate.grid_config";
    private Grid grid;
    private GridCache<Object, Object> dfltCache;
    private AccessType dfltAccessType;
    private final Map<String, String> regionCaches = new HashMap<String, String>();
    private final ConcurrentHashMap8<String, ThreadLocal> threadLocMap = new ConcurrentHashMap8();

    public void start(Settings settings, Properties props) throws CacheException {
        GridLogger log;
        String gridName = props.getProperty(GRID_NAME_PROPERTY);
        if (gridName != null) {
            this.grid = G.grid((String)gridName);
        } else {
            String gridCfg = props.getProperty(GRID_CONFIG_PROPERTY);
            if (gridCfg == null) {
                throw new CacheException("Either grid name or path to grid configuration must be specified.");
            }
            try {
                this.grid = G.start((String)gridCfg);
            }
            catch (GridException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (this.grid == null) {
            throw new CacheException("Grid '" + gridName + "' for hibernate L2 cache is not started.");
        }
        String accessType = props.getProperty(DFLT_ACCESS_TYPE_PROPERTY, AccessType.NONSTRICT_READ_WRITE.name());
        this.dfltAccessType = AccessType.valueOf((String)accessType);
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String key = prop.getKey().toString();
            if (!key.startsWith(REGION_CACHE_PROPERTY)) continue;
            String regionName = key.substring(REGION_CACHE_PROPERTY.length());
            String cacheName = prop.getValue().toString();
            if (this.grid.cache(cacheName) == null) {
                throw new CacheException("Cache '" + cacheName + "' specified for region '" + regionName + "' " + "is not configured.");
            }
            this.regionCaches.put(regionName, cacheName);
        }
        String dfltCacheName = props.getProperty(DFLT_CACHE_NAME_PROPERTY);
        if (dfltCacheName != null) {
            this.dfltCache = this.grid.cache(dfltCacheName);
            if (this.dfltCache == null) {
                throw new CacheException("Cache specified as default is not configured: " + dfltCacheName);
            }
        }
        if ((log = this.grid.log().getLogger(GridHibernateRegionFactory.class)).isDebugEnabled()) {
            log.debug("GridHibernateRegionFactory started [grid=" + gridName + ']');
        }
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public AccessType getDefaultAccessType() {
        return this.dfltAccessType;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties props, CacheDataDescription metadata) throws CacheException {
        return new GridHibernateEntityRegion(this, regionName, this.grid, this.regionCache(regionName), metadata);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties props, CacheDataDescription metadata) throws CacheException {
        return new GridHibernateNaturalIdRegion(this, regionName, this.grid, this.regionCache(regionName), metadata);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties props, CacheDataDescription metadata) throws CacheException {
        return new GridHibernateCollectionRegion(this, regionName, this.grid, this.regionCache(regionName), metadata);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties props) throws CacheException {
        return new GridHibernateQueryResultsRegion(this, regionName, this.grid, this.regionCache(regionName));
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties props) throws CacheException {
        return new GridHibernateTimestampsRegion(this, regionName, this.grid, this.regionCache(regionName));
    }

    ThreadLocal threadLocalForCache(String cacheName) {
        ThreadLocal old;
        ThreadLocal threadLoc = (ThreadLocal)this.threadLocMap.get((Object)cacheName);
        if (threadLoc == null && (old = (ThreadLocal)this.threadLocMap.putIfAbsent((Object)cacheName, threadLoc = new ThreadLocal())) != null) {
            threadLoc = old;
        }
        return threadLoc;
    }

    private GridCache<Object, Object> regionCache(String regionName) throws CacheException {
        GridCache cache;
        String cacheName = this.regionCaches.get(regionName);
        if (cacheName == null) {
            if (this.dfltCache != null) {
                return this.dfltCache;
            }
            cacheName = regionName;
        }
        if ((cache = this.grid.cache(cacheName)) == null) {
            throw new CacheException("Cache '" + cacheName + "' for region '" + regionName + "' is not configured.");
        }
        return cache;
    }
}

