/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.hibernate;

import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.hibernate.GridHibernateAccessStrategyAdapter;
import org.gridgain.grid.lang.GridPredicate;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.jetbrains.annotations.Nullable;

public class GridHibernateTransactionalAccessStrategy
extends GridHibernateAccessStrategyAdapter {
    public GridHibernateTransactionalAccessStrategy(Grid grid, GridCache<Object, Object> cache) {
        super(grid, cache);
    }

    @Override
    @Nullable
    protected Object get(Object key) throws CacheException {
        try {
            return this.cache.get(key);
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void putFromLoad(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new GridPredicate[0]);
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected SoftLock lock(Object key) throws CacheException {
        return null;
    }

    @Override
    protected void unlock(Object key, SoftLock lock) throws CacheException {
    }

    @Override
    protected boolean update(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new GridPredicate[0]);
            return true;
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected boolean afterUpdate(Object key, Object val, SoftLock lock) throws CacheException {
        return false;
    }

    @Override
    protected boolean insert(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new GridPredicate[0]);
            return true;
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected boolean afterInsert(Object key, Object val) throws CacheException {
        return false;
    }

    @Override
    protected void remove(Object key) throws CacheException {
        try {
            this.cache.removex(key, new GridPredicate[0]);
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

