/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.hibernate;

import org.gridgain.grid.Grid;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheAtomicityMode;
import org.gridgain.grid.cache.hibernate.GridHibernateAccessStrategyAdapter;
import org.gridgain.grid.cache.hibernate.GridHibernateNonStrictAccessStrategy;
import org.gridgain.grid.cache.hibernate.GridHibernateReadOnlyAccessStrategy;
import org.gridgain.grid.cache.hibernate.GridHibernateReadWriteAccessStrategy;
import org.gridgain.grid.cache.hibernate.GridHibernateRegion;
import org.gridgain.grid.cache.hibernate.GridHibernateRegionFactory;
import org.gridgain.grid.cache.hibernate.GridHibernateTransactionalAccessStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cache.spi.access.AccessType;

public class GridHibernateTransactionalDataRegion
extends GridHibernateRegion
implements TransactionalDataRegion {
    private final CacheDataDescription dataDesc;

    public GridHibernateTransactionalDataRegion(GridHibernateRegionFactory factory, String name, Grid grid, GridCache<Object, Object> cache, CacheDataDescription dataDesc) {
        super(factory, name, grid, cache);
        this.dataDesc = dataDesc;
    }

    public boolean isTransactionAware() {
        return false;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.dataDesc;
    }

    protected GridHibernateAccessStrategyAdapter createAccessStrategy(AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                return new GridHibernateReadOnlyAccessStrategy(this.grid, (GridCache<Object, Object>)this.cache);
            }
            case NONSTRICT_READ_WRITE: {
                return new GridHibernateNonStrictAccessStrategy(this.grid, (GridCache<Object, Object>)this.cache, this.factory.threadLocalForCache(this.cache.name()));
            }
            case READ_WRITE: {
                if (this.cache.configuration().getAtomicityMode() != GridCacheAtomicityMode.TRANSACTIONAL) {
                    throw new CacheException("Hibernate READ-WRITE access strategy must have GridGain cache with 'TRANSACTIONAL' atomicity mode: " + this.cache.name());
                }
                return new GridHibernateReadWriteAccessStrategy(this.grid, (GridCache<Object, Object>)this.cache, this.factory.threadLocalForCache(this.cache.name()));
            }
            case TRANSACTIONAL: {
                if (this.cache.configuration().getAtomicityMode() != GridCacheAtomicityMode.TRANSACTIONAL) {
                    throw new CacheException("Hibernate TRANSACTIONAL access strategy must have GridGain cache with 'TRANSACTIONAL' atomicity mode: " + this.cache.name());
                }
                if (this.cache.configuration().getTransactionManagerLookupClassName() == null) {
                    throw new CacheException("Hibernate TRANSACTIONAL access strategy must have GridGain cache with TransactionManagerLookup configured: " + this.cache.name());
                }
                return new GridHibernateTransactionalAccessStrategy(this.grid, (GridCache<Object, Object>)this.cache);
            }
        }
        throw new IllegalArgumentException("Unknown Hibernate access type: " + accessType);
    }
}

