package org.gridkit.quickrun;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public interface ConfBean {

    public String readProp(String key);

    public String readProp(String key, String defaultValue);

    public <T> T parseProp(String key, Function<String, T> parser);

    public <T> T parseProp(String key, Function<String, T> parser, T defaultValue);

    public Set<String> keySet();

    public ConfBean subConf(String key);

    public Map<String, ConfBean> listSubConf(String key);
}
