package org.gridkit.quickrun;

public interface Module {

    public boolean isCompleted();

    /**
     * Background modules do not block stage completion and
     */
    public boolean isBackground();

    /**
     * Module may decide to abort scenario execution. E.g. if system under test is down or SLA breached.
     *
     * @return <code>true</code> if scenario should be aborted
     */
    public boolean isAbortRequested();

    public void activate(QuickRunContext context);

    public void onStageCompleted(String stageId);

    public String executionSummary();

    public void shutdown();

}
