package org.gridkit.quickrun;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

import org.gridkit.quickrun.util.TimeExpressionParser;

public class Timer implements BeanProvider {

    @Override
    public Object createInstace(ConfBean conf) {
        TimerModule tm = new TimerModule();
        tm.intervalMs = TimeExpressionParser.parseMillis(conf.readProp("limit"));
        return tm;
    }

    public static class TimerModule implements Module {

        private QuickRunContext context;
        private long intervalMs;
        private long deadlineNs;

        @Override
        public boolean isCompleted() {
            return context.getCurrentTimeNanos() > deadlineNs;
        }

        @Override
        public boolean isBackground() {
            return false;
        }

        @Override
        public boolean isAbortRequested() {
            return false;
        }

        @Override
        public void activate(QuickRunContext context) {
            this.context = context;
            this.deadlineNs = context.getCurrentTimeNanos() + TimeUnit.MILLISECONDS.toNanos(intervalMs);
        }

        @Override
        public void onStageCompleted(String stageId) {
            // do nothing
        }

        @Override
        public String executionSummary() {
            if (isCompleted()) {
                return "";
            } else {
                Duration remTime = Duration.ofSeconds(TimeUnit.NANOSECONDS.toSeconds(deadlineNs - context.getCurrentTimeNanos()));
                return String.format("Time remaining: [%02d:%02d:%02d]\n", remTime.toHours(), remTime.toMinutes() % 60, remTime.getSeconds() % 60);
            }
        }

        @Override
        public void shutdown() {
            // do nothing
        }
    }
}
