package org.gridkit.quickrun.exec;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import org.gridkit.quickrun.exec.TaskSet.TaskWrapper;

/**
 * Hides conditional wait inside {@link Task#start()} method.
 * Useful to enforce certain concurrency control semantics.
 *
 * @author Alexey Ragozin (alexey.ragozin@gmail.com)
 */
public class BlockingTaskWrapper implements TaskWrapper {

    @Override
    public Task wrap(Task task) {
        return new ProxyTask(task) {

            @Override
            public SelectableLatch condition() {
                return null;
            }

            @Override
            public CompletableFuture<Void> start(Executor executor) throws Exception {
                delegate.condition().await();
                return delegate.start(executor);
            }
        };
    }
}
