package org.gridkit.quickrun.exec;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import org.gridkit.quickrun.exec.TaskSet.TaskWrapper;

/**
 * Safety throttle, if number of currently running tasks are above limit execution of next task is skipped.
 * <p>
 * This is useful in combination with open load profiles as a save guard measure.
 *
 * @author Alexey Ragozin (alexey.ragozin@gmail.com)
 */
public class ConcurrencyThrottleGate implements TaskWrapper {

    private final ActiveTaskCounter taskCounter = new ActiveTaskCounter();
    private final int hardLimit;

    public ConcurrencyThrottleGate(int hardLimit) {
        this.hardLimit = hardLimit;
    }

    @Override
    public Task wrap(Task task) {
        return new ProxyTask(taskCounter.wrap(task)) {

            @Override
            public CompletableFuture<Void> start(Executor executor) throws Exception {
                //System.err.println("Active tasks: " + taskCounter.getActiveTaskCount());
                if (taskCounter.getActiveTaskCount() >= hardLimit) {
                    delegate.skip();
                    return CompletableFuture.completedFuture(null);
                } else {
                    return delegate.start(executor);
                }
            }
        };
    }
}
