package org.gridkit.quickrun.exec;

public class DeadlineCondition implements SelectableLatch {

    private long deadlineNS;

    public DeadlineCondition(long deadlineNS) {
        this.deadlineNS = deadlineNS;
    }

    @Override
    public boolean isOpen() {
        return System.nanoTime() >= deadlineNS;
    }

    @Override
    public long proposeWaitTimeNS() {
        return Math.max(1, System.nanoTime() - deadlineNS);
    };
}
