package org.gridkit.quickrun.exec;

import org.gridkit.util.concurrent.BlockingBarrier;

public interface ExecutionManager {

    public ThroughputExecutorBuilder buildThroughputExecetor();

    public ScheduledExecutorBuilder buildScheduledExecutor();

    public void stop();

    public static interface ThroughputExecutorBuilder {

        public ThroughputExecutorBuilder setReporter(TaskWatchWrapper reporter);

        public ThroughputExecutorBuilder setThreadCount(int threadCount);

        public ThroughputExecutorBuilder setShaper(BlockingBarrier barrier);

        public TaskExecutor build();
    }

    public static interface ScheduledExecutorBuilder {

        public ScheduledExecutorBuilder setReporter(TaskWatchWrapper reporter);

        public ScheduledExecutorBuilder setRate(double rate);

        public ScheduledExecutorBuilder setInterval(long intervalMS);

        public ScheduledExecutorBuilder setThreadLimit(int limit);

        public ScheduledExecutorBuilder setInFlightTaskLimit(int limit);

        public ScheduledExecutorBuilder setSkipOnInFlightLimitBreached();

        public TaskExecutor build();
    }
}
