package org.gridkit.quickrun.exec;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

/**
 * Simple task decoration to handle task content execution in separate thread.
 *
 * @author Alexey Ragozin (alexey.ragozin@gmail.com)
 */
public class OffThreadTask {

    private final Executor executor;

    public OffThreadTask(Executor executor) {
        this.executor = executor;
    }

    public Task wrap(Task task) {

        return new ProxyTask(task) {

            @Override
            public CompletableFuture<Void> start(Executor executor) throws Exception {

                final CompletableFuture<Void> fut = new CompletableFuture<>();

                OffThreadTask.this.executor.execute(new Runnable() {

                    @Override
                    public void run() {
                        try {
                            delegate.start(OffThreadTask.this.executor).handle((v, e) -> doHandle(v, e, fut));
                        } catch (Exception e) {
                            doHandle(null, e, fut);
                        }
                    }
                });

                return fut;
            }

            private Void doHandle(Void v, Throwable e, CompletableFuture<Void> fut) {
                if (e == null) {
                    fut.complete(v);
                } else {
                    fut.completeExceptionally(e);
                }
                return null;
            }
        };
    }
}
