package org.gridkit.quickrun.exec;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public abstract class ProxyTask implements Task {

    protected final Task delegate;

    public ProxyTask(Task delegate) {
        this.delegate = delegate;
    }

    @Override
    public SelectableLatch condition() {
        return delegate.condition();
    }

    @Override
    public CompletableFuture<Void> start(Executor executor) throws Exception {
        return delegate.start(executor);
    }

    @Override
    public void skip() {
        delegate.skip();
    }
}
