package org.gridkit.quickrun.exec;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

/**
 * {@link SelectableLatch} is a synchronization primitive. Latch is either closed or open, once it is open it cannot become closed again.
 * <p>
 * It provides somewhat specialized contract comparing to {@link CompletableFuture}.
 * <p>
 * A part of contract is time aware scheduling, time based latch can be implemented without thread usage.
 *
 * @author Alexey Ragozin (alexey.ragozin@gmail.com)
 */
public interface SelectableLatch {

    public static SelectableLatch openLatch() {
        return Latches.openLatch();
    }

    public boolean isOpen();

    public default long proposeWaitTimeNS() { return 0; };

    public default void watch(Consumer<SelectableLatch> watch) {};

    public default void unwatch(Consumer<SelectableLatch> watch) {};

    public default SelectableLatch combine(SelectableLatch latch) {
        return latch == null ? this : new MultiLatch(this, latch);
    }

    public default void await() throws InterruptedException {
        LatchSelector selector  = new LatchSelector();
        selector.add(this);
        try {
            while(true) {
                if (selector.poll(100, TimeUnit.MILLISECONDS) != null) {
                    break;
                }
            }
        } finally {
            selector.clean();
        }
    }
}
