package org.gridkit.quickrun.exec;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class SimpleLatch implements SelectableLatch {

    protected volatile boolean open;

    protected List<Consumer<SelectableLatch>> watchers = new ArrayList<Consumer<SelectableLatch>>();

    @Override
    public boolean isOpen() {
        return open;
    }

    public void open() {
        List<Consumer<SelectableLatch>> toNotify = null;
        synchronized (this) {
            this.open = true;
            toNotify = new ArrayList<>(watchers);
            watchers.clear();
        }

        if (toNotify != null) {
            for (Consumer<SelectableLatch> watch: toNotify) {
                try {
                    watch.accept(this);
                } catch (Error e) {
                    throw e;
                } catch (Exception e) {
                    // ignore exceptions
                }
            }
        }
    }

    @Override
    public void watch(Consumer<SelectableLatch> watch) {
        synchronized (this) {
            if (!open) {
                watchers.add(watch);
                return;
            }
        }
        watch.accept(this);
    }

    @Override
    public synchronized void unwatch(Consumer<SelectableLatch> watch) {
        watchers.remove(watch);
    }
}
