package org.gridkit.quickrun.exec;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class SimpleTaskExecutor implements TaskExecutor, ExecutionUnit {

    private final Executor service;
    // TODO add weak reference to allow WorkUnit garbage collection
    private final List<WorkUnit> jobs = new ArrayList<>();

    public SimpleTaskExecutor(Executor service) {
        this.service = service;
    }

    @Override
    public synchronized void schedule(Job job) {
        job.start(service);
        jobs.add(job);
    }

    @Override
    public synchronized WorkUnit schedule(TaskSet taskSet) {
        Job job = new ThroughputScheduler(taskSet);
        job.start(service);
        jobs.add(job);
        return job;
    }

    @Override
    public synchronized ExecutionUnit newExecutionUnit() {
        SimpleTaskExecutor unit = new SimpleTaskExecutor(service);
        jobs.add(unit);
        return unit;
    }

    @Override
    public synchronized boolean isCompleted() {
        for (WorkUnit j: jobs) {
            if (!j.isCompleted()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void stop() {
        for (WorkUnit j: jobs) {
            j.stop();
        }
    }

    @Override
    public synchronized void join() throws InterruptedException {
        for (WorkUnit j: jobs) {
            j.join();
        }
    }
}
