package org.gridkit.quickrun.exec;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

/**
 * A unit of execution. Unlike {@link Runnable} actual activity could be done asynchronously and implementor has freedom to use CSP style processing.
 *
 * @author Alexey Ragozin (alexey.ragozin@gmail.com)
 */
public interface Task {

    public static Task of(Runnable task) {
        return new Task() {

            @Override
            public CompletableFuture<Void> start(Executor executor) throws Exception {
                task.run();
                return CompletableFuture.completedFuture(null);
            }
        };
    }

    /**
     * Optionally provide condition to be fulfilled for task to run.
     * Executor is not required to check condition, start method is expected to verify own condition in all cases.
     */
    public default SelectableLatch condition() { return null; }

    /**
     * Implementation may execute either synchronously or asynchronously.
     * {@link Executor} is provided for convenience, so adapter could employ non-blocking waiting patterns.
     */
    public CompletableFuture<Void> start(Executor executor) throws Exception;

    /**
     * Invoked if task is omitted from execution, method is useful for reporting purposes;
     */
    public default void skip() {};

}
