package org.gridkit.quickrun.exec;

import java.util.concurrent.atomic.AtomicLong;

import org.gridkit.quickrun.exec.TaskSet.TaskWrapper;

public class TaskCountGate implements TaskWrapper {

    private final AtomicLong counter;

    public TaskCountGate(long taskCountLimit) {
        counter = new AtomicLong(taskCountLimit);
    }

    @Override
    public Task wrap(Task task) {
        long rem = counter.getAndDecrement();
        if (rem > 0) {
            return task;
        } else {
            return null;
        }
    }
}
