package org.gridkit.quickrun.exec;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import org.gridkit.quickrun.exec.TaskSet.TaskWrapper;

/**
 * Interface to collected basic task metrics for statistics and scenario control.
 *
 * @author Alexey Ragozin (alexey.ragozin@gmail.com)
 */
public class TaskWatchWrapper implements TaskWrapper {

    private final TaskWatch watch;

    public TaskWatchWrapper(TaskWatch watch) {
        this.watch = watch;
    }

    @Override
    public Task wrap(Task task) {
        if (task == null) {
            return null;
        }
        return new ProxyTask(task) {

            @Override
            public CompletableFuture<Void> start(Executor executor) throws Exception {
                Instant ts = Instant.now();
                long nt = System.nanoTime();
                return delegate.start(executor).handle((v, e) -> doHandle(ts, nt, e));
            }

            private Void doHandle(Instant ts, long startNs, Throwable e) {
                long dur = System.nanoTime() - startNs;
                if (e == null) {
                    watch.taskCompleted(ts, dur);
                    return null;
                } else {
                    watch.taskFailed(ts, dur);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException) e;
                    } else {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public void skip() {
                try {
                    watch.taskSkipped(Instant.now());
                } catch (RuntimeException e) {
                    // ignore
                }
            }
        };
    }
}
