package org.gridkit.quickrun.exec;

import java.util.concurrent.TimeUnit;

/**
 * Return time associated with taks's scheduled time which may be different from wallclock time.
 *
 * @author Alexey Ragozin (alexey.ragozin@gmail.com)
 */
public class VirtualTime {

    private final static ThreadLocal<TimeHolder> holder = new ThreadLocal<>();

    public static TimeHolder getTimeHolder() {
        return VirtualTime.holder.get();
    }

    public static void setTimeHolder(TimeHolder holder) {
        VirtualTime.holder.set(holder);
    }

    public static long currentTimeMillis() {
        TimeHolder holder = VirtualTime.holder.get();
        return holder == null ? System.currentTimeMillis() : holder.timeMS();
    }

    public static long nanoTime() {
        TimeHolder holder = VirtualTime.holder.get();
        return holder == null ? System.nanoTime() : holder.timeNS();
    }

    public static class TimeHolder {

        private final long anchorMS;
        private final long anchorNS;
        private volatile long offsetNS;

        public TimeHolder() {
            this(System.currentTimeMillis(), System.nanoTime());
        }

        public TimeHolder(long anchorMS, long anchorNS) {
            this.anchorMS = anchorMS;
            this.anchorNS = anchorNS;
        }

        public void setOffset(long offsetNS) {
            this.offsetNS = offsetNS;
        }

        public void addOffset(long offset, TimeUnit tu) {
            this.offsetNS += tu.toNanos(offset);
        }

        public long timeMS() {
            return anchorMS + TimeUnit.NANOSECONDS.toMillis(offsetNS);
        }

        public long timeNS() {
            return anchorNS + offsetNS;
        }
    }
}
