package org.gridkit.quickrun.exec;

public interface WorkUnit {

    /**
     * <b>Warning</b> This method is prone to race condition if tasks are added to unit from outside.
     *
     * @return <code>true</code> if no more pending tasks in this unit.
     */
    public boolean isCompleted();

    /**
     * Abort execution of pending tasks, thread already running may be interrupted.
     */
    public void stop();

    /**
     * Blocks until {@link WorkUnit} is complete.
     * <b>Warning</b> This method is prone to race condition if tasks are added to unit from outside.
     *
     * @throws InterruptedException
     */
    public void join() throws InterruptedException;

}
