package org.gridkit.quickrun.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class FileFinder {

    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();

    /**
     * Scans filesystem and return a list of files matching ant style pattern.
     *
     * <ul> <li>? matches one character</li> <li>* matches zero
     * or more characters</li> <li>** matches zero or more 'directories' in a path</li> </ul>
     *
     * @param match
     * @return
     * @throws IOException
     */
    public static List<File> findFiles(String match) throws IOException {

        match = match.replace('\\', '/');
        String[] path = match.split("[/\\\\]");
        StringBuilder pref = new StringBuilder();
        StringBuilder wc = new StringBuilder();
        boolean haswc = false;
        for (String f: path) {
            if (f.contains("*") || f.contains("?")) {
                haswc = true;
            }
            (haswc ? wc : pref).append(f).append('/');
        }

        if (!match.endsWith("/")) {
            if (wc.length() > 0) {
                wc.setLength(wc.length() - 1);
            } else {
                pref.setLength(pref.length() - 1);
            }
        }

        File base = match.startsWith("/") ? new File('/' + pref.toString()) : new File(pref.toString());
        if (wc.length() == 0) {
            return Arrays.asList(base);
        } else {
            List<File> matches = new ArrayList<>();
            for (File f: listPaths(base)) {
                if (ANT_PATH_MATCHER.match(match, normalize(f.getPath()))) {
                    matches.add(f);
                }
            }
            return matches;
        }
    }

    private static String normalize(String path) {
        return path.replace('\\', '/');
    }

    private static Collection<File> listPaths(File base) {
        List<File> result = new ArrayList<>();
        if (base.isFile()) {
            result.add(base);
            return result;
        } else if (base.isDirectory()) {
            File[] subs = base.listFiles();
            for (File s: subs) {
                result.addAll(listPaths(s));
            }
        }
        return result;
    }
}
