/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URL;
import org.guvnor.common.services.project.backend.server.ProjectServiceImplBaseTest;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

public class ProjectServiceImplResolveTestTests
extends ProjectServiceImplBaseTest {
    @Test
    public void testResolveTestPackageWithNonProjectPath() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL testUrl = this.getClass().getResource("/");
        Path testNioPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)testNioPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTestPackageWithRootPath() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        Package result = projectService.resolvePackage(rootPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTestPackageWithSrcPath() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        Package result = projectService.resolvePackage(rootPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTestPackageWithMainPath() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        Package result = projectService.resolvePackage(rootPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTestPackageDefaultJava() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/java");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/java");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageTestSrcPath().toURI());
    }

    @Test
    public void testResolveTestPackageDefaultResources() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/resources");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/resources");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageTestResourcesPath().toURI());
    }

    @Test
    public void testResolveTestPackageWithJavaFileInPackage() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/java/org/kie/test/project/backend");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/java/org/kie/test/project/backend/BeanTest.java");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageTestSrcPath().toURI());
    }

    @Test
    public void testResolveTestPackageWithResourcesFileInPackage() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/resources/org/kie/test/project/backend");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/resources/org/kie/test/project/backend/test.scenario");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageTestResourcesPath().toURI());
    }
}

