/*
 * Decompiled with CFR 0.152.
 */
package org.gwtopenmaps.demo.openlayers.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtopenmaps.demo.openlayers.client.WingUIManager;
import org.gwtopenmaps.demo.openlayers.client.widget.ShowcaseContent;
import org.gwtopenmaps.demo.openlayers.client.widget.ShowcaseMenu;
import org.gwtopenmaps.openlayers.client.LonLat;
import org.gwtopenmaps.openlayers.client.Map;
import org.gwtopenmaps.openlayers.client.MapOptions;
import org.gwtopenmaps.openlayers.client.MapWidget;
import org.gwtopenmaps.openlayers.client.Size;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.LayerSwitcher;
import org.gwtopenmaps.openlayers.client.control.MousePosition;
import org.gwtopenmaps.openlayers.client.control.NavToolbar;
import org.gwtopenmaps.openlayers.client.control.PanZoomBar;
import org.gwtopenmaps.openlayers.client.control.ScaleLine;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.layer.WMS;
import org.gwtopenmaps.openlayers.client.layer.WMSOptions;
import org.gwtopenmaps.openlayers.client.layer.WMSParams;

public class GwtOpenLayersShowcase
implements EntryPoint {
    public static final String WMS_URL = "http://v2.suite.opengeo.org/geoserver/wms/";
    private Map map;
    private MapOptions defaultMapOptions;
    private WMS wmsLayer;

    public void onModuleLoad() {
        this.defaultMapOptions = new MapOptions();
        this.defaultMapOptions.removeDefaultControls();
        this.defaultMapOptions.setNumZoomLevels(16);
        this.defaultMapOptions.setProjection("EPSG:4326");
        MapWidget mapWidget = new MapWidget("100%", "100%", this.defaultMapOptions);
        this.map = mapWidget.getMap();
        WMSParams wmsParams = new WMSParams();
        wmsParams.setFormat("image/png");
        wmsParams.setLayers("usa:states");
        wmsParams.setStyles("");
        WMSOptions wmsLayerParams = new WMSOptions();
        wmsLayerParams.setTileSize(new Size(256, 256));
        this.wmsLayer = new WMS("Basic WMS", WMS_URL, wmsParams, wmsLayerParams);
        this.map.addLayers(new Layer[]{this.wmsLayer});
        this.map.addControl((Control)new PanZoomBar());
        this.map.addControl((Control)new NavToolbar());
        this.map.addControl((Control)new MousePosition());
        this.map.addControl((Control)new LayerSwitcher());
        this.map.addControl((Control)new ScaleLine());
        double lon = -98.0;
        double lat = 38.0;
        int zoom = 4;
        this.map.setCenter(new LonLat(lon, lat), zoom);
        WingUIManager wing = new WingUIManager();
        ShowcaseContent content = new ShowcaseContent();
        ShowcaseMenu menuPanel = new ShowcaseMenu(wing.getMapZone(), wing.getSouthWestZone());
        wing.getWestCenterZone().add((Widget)menuPanel);
        wing.getMapZone().add((Widget)mapWidget);
        RootLayoutPanel.get().add((Widget)wing);
    }
}

