/*
 * Decompiled with CFR 0.152.
 */
package org.gwtopenmaps.demo.openlayers.client.examples.vector;

import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.gwtopenmaps.demo.openlayers.client.examples.MapExample;
import org.gwtopenmaps.demo.openlayers.client.examples.ShowcaseExample;
import org.gwtopenmaps.openlayers.client.LonLat;
import org.gwtopenmaps.openlayers.client.Pixel;
import org.gwtopenmaps.openlayers.client.Style;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.DragFeature;
import org.gwtopenmaps.openlayers.client.control.DragFeatureOptions;
import org.gwtopenmaps.openlayers.client.control.LayerSwitcher;
import org.gwtopenmaps.openlayers.client.control.MousePosition;
import org.gwtopenmaps.openlayers.client.control.NavToolbar;
import org.gwtopenmaps.openlayers.client.control.PanZoomBar;
import org.gwtopenmaps.openlayers.client.feature.VectorFeature;
import org.gwtopenmaps.openlayers.client.geometry.Geometry;
import org.gwtopenmaps.openlayers.client.geometry.LinearRing;
import org.gwtopenmaps.openlayers.client.geometry.Point;
import org.gwtopenmaps.openlayers.client.geometry.Polygon;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.layer.TransitionEffect;
import org.gwtopenmaps.openlayers.client.layer.Vector;
import org.gwtopenmaps.openlayers.client.layer.VectorOptions;
import org.gwtopenmaps.openlayers.client.layer.WMS;
import org.gwtopenmaps.openlayers.client.layer.WMSOptions;
import org.gwtopenmaps.openlayers.client.layer.WMSParams;

public class DragExample
implements ShowcaseExample {
    public static final String WMS_URL = "http://labs.metacarta.com/wms/vmap0";
    private MapExample example;
    private WMS wmsLayer;
    private TextArea reportArea = new /* Unavailable Anonymous Inner Class!! */;

    public DragExample() {
        this.example = new MapExample();
        WMSParams wmsParams = new WMSParams();
        wmsParams.setFormat("image/png");
        wmsParams.setLayers("basic");
        wmsParams.setStyles("");
        WMSOptions wmsLayerParams = new WMSOptions();
        wmsLayerParams.setUntiled();
        wmsLayerParams.setTransitionEffect(TransitionEffect.RESIZE);
        this.wmsLayer = new WMS("Basic WMS", WMS_URL, wmsParams, wmsLayerParams);
        this.example.getMap().addLayers(new Layer[]{this.wmsLayer});
        this.example.getMap().addControl((Control)new PanZoomBar());
        this.example.getMap().addControl((Control)new NavToolbar());
        this.example.getMap().addControl((Control)new MousePosition());
        this.example.getMap().addControl((Control)new LayerSwitcher());
        this.example.getMap().setCenter(new LonLat(-111.04, 45.68), 4);
        this.example.getMap().addLayer(this.createLayer());
        this.example.add((Widget)this.reportArea);
    }

    public MapExample getMapExample() {
        return this.example;
    }

    private Style createStyle() {
        Style style = new Style();
        style.setStrokeColor("#000000");
        style.setStrokeWidth(3.0);
        style.setFillColor("#FF0000");
        style.setFillOpacity(0.5);
        style.setPointRadius(10.0);
        style.setStrokeOpacity(1.0);
        return style;
    }

    private Layer createLayer() {
        VectorOptions vectorOptions = new VectorOptions();
        vectorOptions.setStyle(this.createStyle());
        Vector layer = new Vector("Vector Layer", vectorOptions);
        Point point = new Point(-111.04, 45.68);
        VectorFeature pointFeature = new VectorFeature((Geometry)point);
        VectorFeature polygonFeature = this.createPolygon(point);
        layer.addFeature(polygonFeature);
        layer.addFeature(pointFeature);
        DragFeature dragFeature = this.createDragFeature(layer);
        this.example.getMap().addControl((Control)dragFeature);
        dragFeature.activate();
        return layer;
    }

    private DragFeature createDragFeature(Vector layer) {
        DragFeatureOptions dragFeatureOptions = new DragFeatureOptions();
        dragFeatureOptions.onDrag(this.createDragFeatureListener("onDrag"));
        dragFeatureOptions.onStart(this.createDragFeatureListener("onStart"));
        dragFeatureOptions.onComplete(this.createDragFeatureListener("onComplete"));
        DragFeature dragFeature = new DragFeature(layer, dragFeatureOptions);
        return dragFeature;
    }

    private DragFeature.DragFeatureListener createDragFeatureListener(String type) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private VectorFeature createPolygon(Point point) {
        Point[] pointList = new Point[7];
        for (int p = 0; p < 6; ++p) {
            Point newPoint;
            double a = (double)p * (Math.PI * 2) / 7.0;
            double r = 3.0;
            pointList[p] = newPoint = new Point(point.getX() + 5.0 + r * Math.cos(a), point.getY() + 5.0 + r * Math.sin(a));
        }
        pointList[6] = pointList[0];
        LinearRing linearRing = new LinearRing(pointList);
        VectorFeature polygonFeature = new VectorFeature((Geometry)new Polygon(new LinearRing[]{linearRing}));
        return polygonFeature;
    }

    protected void report(VectorFeature vectorFeature, String message, Pixel pixel) {
        this.reportArea.setText(vectorFeature.getFeatureId() + " " + message + " (X;Y)=(" + pixel.x() + ";" + pixel.y() + ")\n\n");
    }
}

