/*
 * Decompiled with CFR 0.152.
 */
package org.gwtopenmaps.demo.openlayers.client.examples.vector;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.Widget;
import org.gwtopenmaps.demo.openlayers.client.examples.MapExample;
import org.gwtopenmaps.demo.openlayers.client.examples.ShowcaseExample;
import org.gwtopenmaps.demo.openlayers.client.examples.vector.DrawFeatures;
import org.gwtopenmaps.openlayers.client.LonLat;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.DrawFeature;
import org.gwtopenmaps.openlayers.client.control.DrawFeatureOptions;
import org.gwtopenmaps.openlayers.client.control.EditingToolbar;
import org.gwtopenmaps.openlayers.client.control.SelectFeature;
import org.gwtopenmaps.openlayers.client.control.SelectFeatureOptions;
import org.gwtopenmaps.openlayers.client.handler.Handler;
import org.gwtopenmaps.openlayers.client.handler.HandlerOptions;
import org.gwtopenmaps.openlayers.client.handler.PolygonHandler;
import org.gwtopenmaps.openlayers.client.handler.RegularPolygonHandler;
import org.gwtopenmaps.openlayers.client.handler.RegularPolygonHandlerOptions;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.layer.Vector;
import org.gwtopenmaps.openlayers.client.layer.WMS;
import org.gwtopenmaps.openlayers.client.layer.WMSParams;
import org.gwtopenmaps.openlayers.client.popup.Popup;

public class DrawFeatures
implements ShowcaseExample {
    private final MapExample example;
    private WMS wmsLayer;
    private final Vector vectorLayer = new Vector("Vector layer");
    private final Vector boxLayer = new Vector("Box Layer");
    private Popup popup;

    public DrawFeatures() {
        this.example = new MapExample();
        WMSParams wmsParams = new WMSParams();
        wmsParams.setFormat("image/png");
        wmsParams.setLayers("basic");
        wmsParams.setStyles("");
        this.wmsLayer = new WMS("Basic WMS", "http://labs.metacarta.com/wms/vmap0", wmsParams);
        this.example.getMap().addLayers(new Layer[]{this.wmsLayer});
        double lon = 4.0;
        double lat = 5.0;
        int zoom = 5;
        this.example.getMap().setCenter(new LonLat(lon, lat), zoom);
        this.example.getMap().addLayers(new Layer[]{this.vectorLayer});
        this.example.getMap().addControl((Control)new EditingToolbar(this.vectorLayer));
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        DrawFeatureOptions drawPolygonFeatureOptions = new DrawFeatureOptions();
        drawPolygonFeatureOptions.onFeatureAdded((DrawFeature.FeatureAddedListener)listener);
        DrawFeature drawPolygon = new DrawFeature(this.vectorLayer, (Handler)new PolygonHandler(), drawPolygonFeatureOptions);
        this.example.getMap().addControl((Control)drawPolygon);
        DrawFeatureOptions drawRegularPolygonFeatureOptions = new DrawFeatureOptions();
        drawRegularPolygonFeatureOptions.onFeatureAdded((DrawFeature.FeatureAddedListener)listener);
        RegularPolygonHandlerOptions regularPolygonHandlerOptions = new RegularPolygonHandlerOptions();
        regularPolygonHandlerOptions.setSides(4);
        regularPolygonHandlerOptions.setIrregular(true);
        drawRegularPolygonFeatureOptions.setHandlerOptions((HandlerOptions)regularPolygonHandlerOptions);
        DrawFeature drawRegularPolygon = new DrawFeature(this.boxLayer, (Handler)new RegularPolygonHandler(), drawRegularPolygonFeatureOptions);
        this.example.getMap().addControl((Control)drawRegularPolygon);
        SelectFeatureOptions selectFeatureOptions = new SelectFeatureOptions();
        selectFeatureOptions.onSelect((SelectFeature.SelectFeatureListener)new /* Unavailable Anonymous Inner Class!! */);
        SelectFeature selectFeature = new SelectFeature(this.vectorLayer, selectFeatureOptions);
        this.example.getMap().addControl((Control)selectFeature);
        ToggleButton drawPolygonBtn = new ToggleButton("Draw Polygon");
        ToggleButton drawRegularPolygonBtn = new ToggleButton("Draw Rectangle");
        ToggleButton selectPolygonFeatureBtn = new ToggleButton("Select Polygon");
        ToggleButton selectRegularPolygonFeatureBtn = new ToggleButton("Select Rectangle");
        drawPolygonBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        drawRegularPolygonBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        selectPolygonFeatureBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        selectRegularPolygonFeatureBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Grid buttons = new Grid(2, 2);
        buttons.setWidget(0, 0, (Widget)drawPolygonBtn);
        buttons.setWidget(0, 1, (Widget)drawRegularPolygonBtn);
        buttons.setWidget(1, 0, (Widget)selectPolygonFeatureBtn);
        buttons.setWidget(1, 1, (Widget)selectRegularPolygonFeatureBtn);
        this.example.add((Widget)buttons);
        this.example.getMap().addLayer((Layer)this.boxLayer);
    }

    public MapExample getMapExample() {
        return this.example;
    }

    static /* synthetic */ Popup access$002(DrawFeatures x0, Popup x1) {
        x0.popup = x1;
        return x0.popup;
    }

    static /* synthetic */ Popup access$000(DrawFeatures x0) {
        return x0.popup;
    }

    static /* synthetic */ MapExample access$100(DrawFeatures x0) {
        return x0.example;
    }
}

