/*
 * Decompiled with CFR 0.152.
 */
package org.gwtopenmaps.demo.openlayers.client.examples.vector;

import org.gwtopenmaps.demo.openlayers.client.examples.MapExample;
import org.gwtopenmaps.demo.openlayers.client.examples.ShowcaseExample;
import org.gwtopenmaps.openlayers.client.LonLat;
import org.gwtopenmaps.openlayers.client.Style;
import org.gwtopenmaps.openlayers.client.StyleMap;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.DragFeature;
import org.gwtopenmaps.openlayers.client.control.DragFeatureOptions;
import org.gwtopenmaps.openlayers.client.control.LayerSwitcher;
import org.gwtopenmaps.openlayers.client.control.MousePosition;
import org.gwtopenmaps.openlayers.client.control.NavToolbar;
import org.gwtopenmaps.openlayers.client.control.PanZoomBar;
import org.gwtopenmaps.openlayers.client.feature.VectorFeature;
import org.gwtopenmaps.openlayers.client.geometry.Geometry;
import org.gwtopenmaps.openlayers.client.geometry.LinearRing;
import org.gwtopenmaps.openlayers.client.geometry.Point;
import org.gwtopenmaps.openlayers.client.geometry.Polygon;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.layer.TransitionEffect;
import org.gwtopenmaps.openlayers.client.layer.Vector;
import org.gwtopenmaps.openlayers.client.layer.VectorOptions;
import org.gwtopenmaps.openlayers.client.layer.WMS;
import org.gwtopenmaps.openlayers.client.layer.WMSOptions;
import org.gwtopenmaps.openlayers.client.layer.WMSParams;
import org.gwtopenmaps.openlayers.client.util.Attributes;

public class LabeledFeature
implements ShowcaseExample {
    public static final String WMS_URL = "http://labs.metacarta.com/wms/vmap0";
    private MapExample example = new MapExample();
    private WMS wmsLayer;
    private Vector labeledLayer;
    private Vector labeledLayerPicture;

    public LabeledFeature() {
        WMSParams wmsParams = new WMSParams();
        wmsParams.setFormat("image/png");
        wmsParams.setLayers("basic");
        wmsParams.setStyles("");
        WMSOptions wmsLayerParams = new WMSOptions();
        wmsLayerParams.setUntiled();
        wmsLayerParams.setTransitionEffect(TransitionEffect.RESIZE);
        this.wmsLayer = new WMS("Basic WMS", WMS_URL, wmsParams, wmsLayerParams);
        this.example.getMap().addLayers(new Layer[]{this.wmsLayer});
        this.example.getMap().addControl((Control)new PanZoomBar());
        this.example.getMap().addControl((Control)new NavToolbar());
        this.example.getMap().addControl((Control)new MousePosition());
        this.example.getMap().addControl((Control)new LayerSwitcher());
        this.example.getMap().setCenter(new LonLat(-111.04, 45.68), 3);
        this.createLabelLayer();
    }

    public MapExample getMapExample() {
        return this.example;
    }

    private void createLabelLayer() {
        Style styleVector = new Style();
        styleVector.setStrokeColor("#00FF00");
        styleVector.setStrokeWidth(3.0);
        styleVector.setFillColor("#FFFF00");
        styleVector.setFillOpacity(0.5);
        styleVector.setPointRadius(6.0);
        styleVector.setStrokeOpacity(1.0);
        styleVector.setLabel("name: ${name}, age: ${age}");
        styleVector.setFontColor("${favColor}");
        styleVector.setFontSize("12px");
        styleVector.setFontFamily("Courier New, monospace");
        styleVector.setFontWeight("bold");
        styleVector.setLabelAlign("${align}");
        Style stylePicture = new Style();
        stylePicture.setFillOpacity(1.0);
        stylePicture.setExternalGraphic("${picture}");
        stylePicture.setGraphicSize(64, 35);
        stylePicture.setPointRadius(30.0);
        stylePicture.setGraphicOffset(-32, -30);
        stylePicture.setLabel("${plate}");
        stylePicture.setFillColor("black");
        stylePicture.setFontColor("${favColor}");
        stylePicture.setFontSize("12px");
        stylePicture.setFontFamily("Courier New, monospace");
        stylePicture.setFontWeight("bold");
        stylePicture.setLabelAlign("cb");
        StyleMap styleMapVector = new StyleMap(styleVector);
        StyleMap styleMapPicture = new StyleMap(stylePicture);
        VectorOptions vectorOptions = new VectorOptions();
        vectorOptions.setStyleMap(styleMapVector);
        VectorOptions vectorOptionsPicture = new VectorOptions();
        vectorOptionsPicture.setStyleMap(styleMapPicture);
        this.labeledLayer = new Vector("Labels", vectorOptions);
        this.labeledLayerPicture = new Vector("Labels Picture", vectorOptionsPicture);
        this.example.getMap().addLayer((Layer)this.labeledLayerPicture);
        this.example.getMap().addLayer((Layer)this.labeledLayer);
        Point point = new Point(-111.04, 45.68);
        VectorFeature pointFeature = new VectorFeature((Geometry)point);
        pointFeature.setAttributes((Attributes)new /* Unavailable Anonymous Inner Class!! */);
        Point[] pointList = new Point[7];
        for (int p = 0; p < 6; ++p) {
            Point newPoint;
            double a = (double)p * (Math.PI * 2) / 7.0;
            double r = Math.random() + 1.0;
            pointList[p] = newPoint = new Point(point.getX() + 5.0 + r * Math.cos(a), point.getY() + 5.0 + r * Math.sin(a));
        }
        pointList[6] = pointList[0];
        LinearRing linearRing = new LinearRing(pointList);
        VectorFeature polygonFeature = new VectorFeature((Geometry)new Polygon(new LinearRing[]{linearRing}));
        polygonFeature.setAttributes((Attributes)new /* Unavailable Anonymous Inner Class!! */);
        VectorFeature imageFeatureRedCar = new VectorFeature((Geometry)new Point(point.getX() + 5.0, point.getY() - 10.0));
        imageFeatureRedCar.setAttributes((Attributes)new /* Unavailable Anonymous Inner Class!! */);
        VectorFeature imageFeatureBlueCar = new VectorFeature((Geometry)new Point(point.getX() - 5.0, point.getY() + 10.0));
        imageFeatureBlueCar.setAttributes((Attributes)new /* Unavailable Anonymous Inner Class!! */);
        this.labeledLayer.addFeature(polygonFeature);
        this.labeledLayer.addFeature(pointFeature);
        this.labeledLayerPicture.addFeature(imageFeatureRedCar);
        this.labeledLayerPicture.addFeature(imageFeatureBlueCar);
        DragFeatureOptions dragFeatureOptions = new DragFeatureOptions();
        dragFeatureOptions.onComplete((DragFeature.DragFeatureListener)new /* Unavailable Anonymous Inner Class!! */);
        DragFeature dragFeature = new DragFeature(this.labeledLayerPicture, dragFeatureOptions);
        this.example.getMap().addControl((Control)dragFeature);
        dragFeature.activate();
    }
}

