/*
 * Decompiled with CFR 0.152.
 */
package org.gwtopenmaps.demo.openlayers.client.examples.vector;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtopenmaps.demo.openlayers.client.examples.MapExample;
import org.gwtopenmaps.demo.openlayers.client.examples.ShowcaseExample;
import org.gwtopenmaps.demo.openlayers.client.examples.vector.ModifyFeatureExample;
import org.gwtopenmaps.openlayers.client.LonLat;
import org.gwtopenmaps.openlayers.client.Style;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.LayerSwitcher;
import org.gwtopenmaps.openlayers.client.control.ModifyFeature;
import org.gwtopenmaps.openlayers.client.control.MousePosition;
import org.gwtopenmaps.openlayers.client.control.NavToolbar;
import org.gwtopenmaps.openlayers.client.control.PanZoomBar;
import org.gwtopenmaps.openlayers.client.event.VectorFeatureModifiedListener;
import org.gwtopenmaps.openlayers.client.feature.VectorFeature;
import org.gwtopenmaps.openlayers.client.geometry.Geometry;
import org.gwtopenmaps.openlayers.client.geometry.LinearRing;
import org.gwtopenmaps.openlayers.client.geometry.Point;
import org.gwtopenmaps.openlayers.client.geometry.Polygon;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.layer.TransitionEffect;
import org.gwtopenmaps.openlayers.client.layer.Vector;
import org.gwtopenmaps.openlayers.client.layer.VectorOptions;
import org.gwtopenmaps.openlayers.client.layer.WMS;
import org.gwtopenmaps.openlayers.client.layer.WMSOptions;
import org.gwtopenmaps.openlayers.client.layer.WMSParams;

public class ModifyFeatureExample
implements ShowcaseExample {
    public static final String WMS_URL = "http://labs.metacarta.com/wms/vmap0";
    private MapExample example = new MapExample();
    private WMS wmsLayer;
    private VerticalPanel operationContents;
    private TextArea reportArea = new /* Unavailable Anonymous Inner Class!! */;
    private ModifyFeature modifyFeature;
    private int reportCount = 0;

    public ModifyFeatureExample() {
        WMSParams wmsParams = new WMSParams();
        wmsParams.setFormat("image/png");
        wmsParams.setLayers("basic");
        wmsParams.setStyles("");
        WMSOptions wmsLayerParams = new WMSOptions();
        wmsLayerParams.setUntiled();
        wmsLayerParams.setTransitionEffect(TransitionEffect.RESIZE);
        this.wmsLayer = new WMS("Basic WMS", WMS_URL, wmsParams, wmsLayerParams);
        this.example.getMap().addLayers(new Layer[]{this.wmsLayer});
        this.example.getMap().addControl((Control)new PanZoomBar());
        this.example.getMap().addControl((Control)new NavToolbar());
        this.example.getMap().addControl((Control)new MousePosition());
        this.example.getMap().addControl((Control)new LayerSwitcher());
        this.example.getMap().setCenter(new LonLat(-111.04, 45.68), 4);
        this.example.getMap().addLayer(this.createLayer());
        this.createOperationContents();
    }

    private void createOperationContents() {
        this.operationContents = new VerticalPanel();
        this.operationContents.add((Widget)this.createModeButton("Resize", 2));
        this.operationContents.add((Widget)this.createModeButton("Drag", 8));
        this.operationContents.add((Widget)this.createModeButton("Reshape", 1));
        this.operationContents.add((Widget)this.createModeButton("Rotate", 4));
    }

    public VerticalPanel getOperationContents() {
        return this.operationContents;
    }

    public void setOperationContents(VerticalPanel operationContents) {
        this.operationContents = operationContents;
    }

    private Button createModeButton(String labelText, int mode) {
        2 button = new /* Unavailable Anonymous Inner Class!! */;
        return button;
    }

    public MapExample getMapExample() {
        return this.example;
    }

    private Style createStyle() {
        Style style = new Style();
        style.setStrokeColor("#000000");
        style.setStrokeWidth(1.0);
        style.setFillColor("#FF0000");
        style.setFillOpacity(0.5);
        style.setPointRadius(5.0);
        style.setStrokeOpacity(1.0);
        return style;
    }

    private Layer createLayer() {
        VectorOptions vectorOptions = new VectorOptions();
        vectorOptions.setStyle(this.createStyle());
        Vector layer = new Vector("Vector Layer", vectorOptions);
        Point point = new Point(-111.04, 45.68);
        VectorFeature polygonFeature = this.createPolygon(point);
        layer.addFeature(polygonFeature);
        this.modifyFeature = this.createModifyFeature(layer);
        this.example.getMap().addControl((Control)this.modifyFeature);
        this.modifyFeature.activate();
        layer.addVectorFeatureModifiedListener((VectorFeatureModifiedListener)new /* Unavailable Anonymous Inner Class!! */);
        return layer;
    }

    private ModifyFeature createModifyFeature(Vector layer) {
        ModifyFeature modifyFeature = new ModifyFeature(layer);
        return modifyFeature;
    }

    private VectorFeature createPolygon(Point point) {
        Point[] pointList = new Point[7];
        for (int p = 0; p < 6; ++p) {
            Point newPoint;
            double a = (double)p * (Math.PI * 2) / 7.0;
            double r = 3.0;
            pointList[p] = newPoint = new Point(point.getX() + 5.0 + r * Math.cos(a), point.getY() + 5.0 + r * Math.sin(a));
        }
        pointList[6] = pointList[0];
        LinearRing linearRing = new LinearRing(pointList);
        VectorFeature polygonFeature = new VectorFeature((Geometry)new Polygon(new LinearRing[]{linearRing}));
        return polygonFeature;
    }

    protected void report(VectorFeature vectorFeature, String message) {
        this.reportArea.setText(this.reportCount++ + ")" + vectorFeature.getFeatureId() + " " + message + "\n\n");
    }

    static /* synthetic */ ModifyFeature access$000(ModifyFeatureExample x0) {
        return x0.modifyFeature;
    }
}

