/*
 * Decompiled with CFR 0.152.
 */
package org.gwtopenmaps.demo.openlayers.client.examples.vector;

import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.gwtopenmaps.demo.openlayers.client.examples.MapExample;
import org.gwtopenmaps.demo.openlayers.client.examples.ShowcaseExample;
import org.gwtopenmaps.openlayers.client.LonLat;
import org.gwtopenmaps.openlayers.client.RenderIntent;
import org.gwtopenmaps.openlayers.client.Style;
import org.gwtopenmaps.openlayers.client.StyleMap;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.LayerSwitcher;
import org.gwtopenmaps.openlayers.client.control.MousePosition;
import org.gwtopenmaps.openlayers.client.control.NavToolbar;
import org.gwtopenmaps.openlayers.client.control.PanZoomBar;
import org.gwtopenmaps.openlayers.client.control.SelectFeature;
import org.gwtopenmaps.openlayers.client.control.SelectFeatureOptions;
import org.gwtopenmaps.openlayers.client.event.BeforeFeatureHighlightedListener;
import org.gwtopenmaps.openlayers.client.event.FeatureHighlightedListener;
import org.gwtopenmaps.openlayers.client.event.FeatureUnhighlightedListener;
import org.gwtopenmaps.openlayers.client.feature.VectorFeature;
import org.gwtopenmaps.openlayers.client.geometry.Geometry;
import org.gwtopenmaps.openlayers.client.geometry.LinearRing;
import org.gwtopenmaps.openlayers.client.geometry.Point;
import org.gwtopenmaps.openlayers.client.geometry.Polygon;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.layer.TransitionEffect;
import org.gwtopenmaps.openlayers.client.layer.Vector;
import org.gwtopenmaps.openlayers.client.layer.VectorOptions;
import org.gwtopenmaps.openlayers.client.layer.WMS;
import org.gwtopenmaps.openlayers.client.layer.WMSOptions;
import org.gwtopenmaps.openlayers.client.layer.WMSParams;

public class SelectFeatureExamples
implements ShowcaseExample {
    public static final String WMS_URL = "http://labs.metacarta.com/wms/vmap0";
    private MapExample example;
    private WMS wmsLayer;
    private TextArea reportArea = new /* Unavailable Anonymous Inner Class!! */;

    public SelectFeatureExamples() {
        this.example = new MapExample();
        WMSParams wmsParams = new WMSParams();
        wmsParams.setFormat("image/png");
        wmsParams.setLayers("basic");
        wmsParams.setStyles("");
        WMSOptions wmsLayerParams = new WMSOptions();
        wmsLayerParams.setUntiled();
        wmsLayerParams.setTransitionEffect(TransitionEffect.RESIZE);
        this.wmsLayer = new WMS("Basic WMS", WMS_URL, wmsParams, wmsLayerParams);
        this.example.getMap().addLayers(new Layer[]{this.wmsLayer});
        this.example.getMap().addControl((Control)new PanZoomBar());
        this.example.getMap().addControl((Control)new NavToolbar());
        this.example.getMap().addControl((Control)new MousePosition());
        this.example.getMap().addControl((Control)new LayerSwitcher());
        this.example.getMap().setCenter(new LonLat(-111.04, 45.68), 3);
        this.example.getMap().addLayer(this.createLayer());
        this.example.add((Widget)this.reportArea);
    }

    public MapExample getMapExample() {
        return this.example;
    }

    private Style createStyle(String fillColor) {
        Style style = new Style();
        style.setStrokeColor("#000000");
        style.setStrokeWidth(3.0);
        style.setFillColor(fillColor);
        style.setFillOpacity(0.5);
        style.setPointRadius(10.0);
        style.setStrokeOpacity(1.0);
        return style;
    }

    private Layer createLayer() {
        Style styleNormal = this.createStyle("#FF0000");
        Style styleSelected = this.createStyle("#00FF00");
        Style styleHighlighted = this.createStyle("#0000FF");
        StyleMap styleMapVector = new StyleMap(styleNormal, styleSelected, styleHighlighted);
        VectorOptions vectorOptions = new VectorOptions();
        vectorOptions.setStyleMap(styleMapVector);
        Vector layer = new Vector("SelectFeature Layer", vectorOptions);
        Point point = new Point(-111.04, 45.68);
        VectorFeature pointFeature = new VectorFeature((Geometry)point);
        Point[] pointList = new Point[7];
        for (int p = 0; p < 6; ++p) {
            Point newPoint;
            double a = (double)p * (Math.PI * 2) / 7.0;
            double r = Math.random() + 1.0;
            pointList[p] = newPoint = new Point(point.getX() + 5.0 + r * Math.cos(a), point.getY() + 5.0 + r * Math.sin(a));
        }
        pointList[6] = pointList[0];
        LinearRing linearRing = new LinearRing(pointList);
        VectorFeature polygonFeature = new VectorFeature((Geometry)new Polygon(new LinearRing[]{linearRing}));
        layer.addFeature(polygonFeature);
        layer.addFeature(pointFeature);
        SelectFeature selectFeatureHover = new SelectFeature(layer, this.createSelectFeatureOptions(true));
        selectFeatureHover.addBeforeFeatureHighlightedListener((BeforeFeatureHighlightedListener)new /* Unavailable Anonymous Inner Class!! */);
        selectFeatureHover.addFeatureHighlightedListener((FeatureHighlightedListener)new /* Unavailable Anonymous Inner Class!! */);
        selectFeatureHover.addFeatureUnhighlightedListener((FeatureUnhighlightedListener)new /* Unavailable Anonymous Inner Class!! */);
        SelectFeature selectFeatureClick = new SelectFeature(layer, this.createSelectFeatureOptions(false));
        this.example.getMap().addControl((Control)selectFeatureClick);
        this.example.getMap().addControl((Control)selectFeatureHover);
        selectFeatureHover.activate();
        selectFeatureClick.activate();
        return layer;
    }

    private SelectFeatureOptions createSelectFeatureOptions(boolean isHover) {
        SelectFeatureOptions selectFeatureOptions = new SelectFeatureOptions();
        if (isHover) {
            selectFeatureOptions.setHover();
            selectFeatureOptions.setHighlightOnly(true);
            selectFeatureOptions.setRenderIntent(RenderIntent.TEMPORARY);
        }
        selectFeatureOptions.onSelect((SelectFeature.SelectFeatureListener)new /* Unavailable Anonymous Inner Class!! */);
        selectFeatureOptions.onUnSelect((SelectFeature.UnselectFeatureListener)new /* Unavailable Anonymous Inner Class!! */);
        return selectFeatureOptions;
    }

    protected void report(VectorFeature vectorFeature, String message) {
        this.reportArea.setText(this.reportArea.getText() + vectorFeature.getFeatureId() + " " + message + "\n\n");
    }
}

