/*
 * Decompiled with CFR 0.152.
 */
package org.hammerlab.channel;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.hammerlab.channel.ByteChannel;
import org.hammerlab.io.Buffer$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class ByteChannel$class {
    public static void readFully(ByteChannel $this, ByteBuffer dst) {
        int numRead;
        int numToRead = dst.remaining();
        int lastRead = -1;
        for (int totalRead = 0; totalRead < numToRead; totalRead += numRead) {
            numRead = $this.read(dst);
            if (numRead == -1) {
                throw new EOFException();
            }
            if (numRead == 0 && lastRead == 0) {
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read 0 bytes twice in a row, ", " bytes into reading ", " from position ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)totalRead), BoxesRunTime.boxToInteger((int)numToRead), BoxesRunTime.boxToLong((long)($this.position() - (long)totalRead))})));
            }
            lastRead = numRead;
        }
    }

    public static void readFully(ByteChannel $this, byte[] bytes) {
        $this.readFully(bytes, 0, bytes.length);
    }

    public static void readFully(ByteChannel $this, byte[] bytes, int offset, int numToRead) {
        int numRead;
        int lastRead = -1;
        int offset2 = 0;
        for (int numLeft = numToRead; numLeft > 0; numLeft -= numRead) {
            numRead = $this.read(bytes, offset2, numLeft);
            if (numRead == -1) {
                throw new EOFException();
            }
            if (numRead == 0 && lastRead == 0) {
                int totalRead = numToRead - numLeft;
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read 0 bytes twice in a row, ", " bytes into reading ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)totalRead), BoxesRunTime.boxToInteger((int)numToRead), BoxesRunTime.boxToLong((long)($this.position() - (long)totalRead))})));
            }
            offset2 += numRead;
            lastRead = numRead;
        }
    }

    public static final int read(ByteChannel $this) {
        int n;
        int n2 = $this._read();
        switch (n2) {
            default: {
                $this._position_$eq($this._position() + 1L);
                n = n2;
                break;
            }
            case -1: {
                n = -1;
            }
        }
        return n;
    }

    public static final int read(ByteChannel $this, byte[] b) {
        return $this.read(b, 0, b.length);
    }

    public static final int read(ByteChannel $this, byte[] b, int off, int len) {
        int n;
        int n2 = $this._read(b, off, len);
        switch (n2) {
            default: {
                $this._position_$eq($this._position() + (long)n2);
                n = n2;
                break;
            }
            case -1: {
                n = -1;
            }
        }
        return n;
    }

    public static final int read(ByteChannel $this, ByteBuffer dst) {
        int n;
        int n2 = $this._read(dst);
        switch (n2) {
            default: {
                $this._position_$eq($this._position() + (long)n2);
                n = n2;
                break;
            }
            case -1: {
                n = -1;
            }
        }
        return n;
    }

    public static String readString(ByteChannel $this, int length, boolean includesNull) {
        int x$4 = length;
        ByteOrder x$5 = Buffer$.MODULE$.apply$default$2(x$4);
        ByteBuffer buffer = Buffer$.MODULE$.apply(x$4, x$5);
        $this.read(buffer);
        return Predef$.MODULE$.charArrayOps((char[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(buffer.array()).slice(0, includesNull ? length - 1 : length)).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final char apply(byte x$1) {
                return (char)x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char()))).mkString("");
    }

    public static boolean readString$default$2(ByteChannel $this) {
        return true;
    }

    public static ByteBuffer b4(ByteChannel $this) {
        int x$2 = 4;
        ByteOrder x$3 = Buffer$.MODULE$.apply$default$2(x$2);
        return Buffer$.MODULE$.apply(x$2, x$3);
    }

    public static void order(ByteChannel $this, ByteOrder order) {
        $this.b4().order(order);
    }

    public static int getInt(ByteChannel $this) {
        $this.b4().position(0);
        $this.readFully($this.b4());
        return $this.b4().getInt(0);
    }

    public static final void skip(ByteChannel $this, int n) {
        $this._skip(n);
        $this._position_$eq($this._position() + (long)n);
    }

    public static long position(ByteChannel $this) {
        return $this._position();
    }

    public static final void close(ByteChannel $this) {
        $this.org$hammerlab$channel$ByteChannel$$_closed_$eq(true);
        $this._close();
    }

    public static void _close(ByteChannel $this) {
    }

    public static boolean isOpen(ByteChannel $this) {
        return !$this.org$hammerlab$channel$ByteChannel$$_closed();
    }

    public static void $init$(ByteChannel $this) {
        $this._position_$eq(0L);
        $this.org$hammerlab$channel$ByteChannel$$_closed_$eq(false);
    }
}

