/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.context;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;

public final class ApplicationContextHolder {
    private static final ConcurrentHashMap<ClassLoader, ApplicationContext> CONTEXT_MAP = new ConcurrentHashMap();

    private ApplicationContextHolder() {
    }

    public static ApplicationContext getRequiredApplicationContext() {
        ApplicationContext context = ApplicationContextHolder.getApplicationContext();
        if (context == null) {
            throw new IllegalStateException("No ApplicationContext found");
        }
        return context;
    }

    public static ApplicationContext getApplicationContext() {
        for (ClassLoader classLoader = ApplicationContextHolder.getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            ApplicationContext applicationContext = CONTEXT_MAP.get(classLoader);
            if (applicationContext == null) continue;
            return applicationContext;
        }
        return null;
    }

    public static void bind(ApplicationContext context) {
        ApplicationContext old = CONTEXT_MAP.putIfAbsent(ApplicationContextHolder.getContextClassLoader(), context);
        if (old != null) {
            throw new IllegalStateException("ApplicationContext already bound to the class loader of the current thread");
        }
    }

    public static void release() {
        CONTEXT_MAP.remove(ApplicationContextHolder.getContextClassLoader());
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Unable to get the class loader for the current thread");
        }
        return classLoader;
    }
}

