/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hawaiiframework.converter.DefaultNullListConversionStrategies;
import org.hawaiiframework.converter.ModelConverter;
import org.hawaiiframework.converter.NullListConversionStrategy;
import org.springframework.beans.BeanUtils;

public abstract class AbstractModelConverter<S, T>
implements ModelConverter<S, T> {
    private final Class<T> targetType;
    private final NullListConversionStrategy<T> nullListConversionStrategy;

    public AbstractModelConverter(Class<T> targetType) {
        this(targetType, DefaultNullListConversionStrategies.returnEmptyList(targetType));
    }

    public AbstractModelConverter(Class<T> targetType, NullListConversionStrategy<T> nullListConversionStrategy) {
        this.targetType = Objects.requireNonNull(targetType, "'targetType' must not be null");
        this.nullListConversionStrategy = Objects.requireNonNull(nullListConversionStrategy, "'nullListConversionStrategy' must not be null");
    }

    @Override
    public T convert(S source) {
        if (source == null) {
            return null;
        }
        T target = this.instantiateTargetObject(source);
        this.convert(source, target);
        return target;
    }

    @Override
    public List<T> convert(Iterable<? extends S> objects) {
        if (objects == null) {
            return this.nullListConversionStrategy.apply();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (S object : objects) {
            result.add(this.convert(object));
        }
        return result;
    }

    protected T instantiateTargetObject(S source) {
        return (T)BeanUtils.instantiateClass(this.targetType);
    }
}

