/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.crypto;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.hawaiiframework.exception.HawaiiException;
import org.jasypt.encryption.StringEncryptor;

public class HawaiiStringEncryptor
implements StringEncryptor {
    private final String key;
    private final String initVector;

    public HawaiiStringEncryptor(String key, String initVector) {
        this.key = Objects.requireNonNull(key);
        this.initVector = Objects.requireNonNull(initVector);
    }

    public String encrypt(String message) {
        try {
            Cipher cipher = this.initCipher(1, this.key, this.initVector);
            byte[] encrypted = cipher.doFinal(message.getBytes(Charset.defaultCharset()));
            return Base64.toBase64String((byte[])encrypted);
        }
        catch (GeneralSecurityException e) {
            throw new HawaiiException("Error encrypting message", e);
        }
    }

    public String decrypt(String encryptedMessage) {
        try {
            Cipher cipher = this.initCipher(2, this.key, this.initVector);
            byte[] decrypted = cipher.doFinal(Base64.decode((String)encryptedMessage));
            return new String(decrypted, Charset.defaultCharset());
        }
        catch (GeneralSecurityException e) {
            throw new HawaiiException("Error decrypting message", e);
        }
    }

    protected Cipher initCipher(int mode, String key, String initVector) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.hexStringToByteArray(key), "AES");
        IvParameterSpec initVectorSpec = new IvParameterSpec(this.hexStringToByteArray(initVector));
        cipher.init(mode, (Key)secretKeySpec, initVectorSpec);
        return cipher;
    }

    private byte[] hexStringToByteArray(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + s);
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int high = this.hexToBin(s.charAt(i));
            int low = this.hexToBin(s.charAt(i + 1));
            if (high == -1 || low == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + s);
            }
            out[i / 2] = (byte)(high * 16 + low);
        }
        return out;
    }

    private int hexToBin(char ch) {
        int bin = '0' <= ch && ch <= '9' ? ch - 48 : ('A' <= ch && ch <= 'F' ? ch - 65 + 10 : ('a' <= ch && ch <= 'f' ? ch - 97 + 10 : -1));
        return bin;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

