/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.crypto;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.UrlBase64;
import org.hawaiiframework.crypto.HawaiiStringEncryptor;
import org.hawaiiframework.exception.HawaiiException;

public class HawaiiUrlSafeStringEncryptor
extends HawaiiStringEncryptor {
    private final String key;
    private final String initVector;

    public HawaiiUrlSafeStringEncryptor(String key, String initVector) {
        super(key, initVector);
        this.key = key;
        this.initVector = initVector;
    }

    @Override
    public String encrypt(String message) {
        try {
            Cipher cipher = this.initCipher(1, this.key, this.initVector);
            byte[] encrypted = cipher.doFinal(message.getBytes(Charset.defaultCharset()));
            byte[] encoded = UrlBase64.encode((byte[])encrypted);
            return Strings.fromByteArray((byte[])encoded);
        }
        catch (GeneralSecurityException e) {
            throw new HawaiiException("Error encrypting message", e);
        }
    }

    @Override
    public String decrypt(String encryptedMessage) {
        try {
            Cipher cipher = this.initCipher(2, this.key, this.initVector);
            byte[] decrypted = cipher.doFinal(UrlBase64.decode((String)encryptedMessage));
            return new String(decrypted, Charset.defaultCharset());
        }
        catch (GeneralSecurityException e) {
            throw new HawaiiException("Error decrypting message", e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

