/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.crypto;

import org.hawaiiframework.crypto.HawaiiStringEncryptor;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
public class StringEncryptorConfig {
    private static final Integer NUM_PARTS = 2;
    @Value(value="${hawaii.crypto.init:}")
    private String encryptionInitProperty;

    @Bean(value={"jasyptStringEncryptor"})
    public StringEncryptor stringEncryptor() {
        Assert.hasLength((String)this.encryptionInitProperty, (String)"Encryption cannot be initialized without 'hawaii.crypto.init' configuration. Or disable via 'hawaii.crypto.enabled: false'.");
        String encryptionInit = System.getenv(this.encryptionInitProperty);
        Assert.hasLength((String)encryptionInit, (String)String.format("Encryption cannot be initialized without '%s' environment variable.", this.encryptionInitProperty));
        String[] parts = this.splitEncryptionInitializationString(encryptionInit);
        return this.createStringEncryptor(parts);
    }

    private StringEncryptor createStringEncryptor(String ... parts) {
        return new HawaiiStringEncryptor(parts[0], parts[1]);
    }

    private String[] splitEncryptionInitializationString(String encryptionInit) {
        String[] parts = encryptionInit.split(":");
        if (parts.length != NUM_PARTS) {
            throw new IllegalArgumentException(String.format("The environment variable '%s' must consist of two parts, separated by a colon.", encryptionInit));
        }
        return parts;
    }

    public void setEncryptionInitProperty(String encryptionInitProperty) {
        this.encryptionInitProperty = encryptionInitProperty;
    }
}

