/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.repository;

import java.util.List;
import javax.sql.DataSource;
import org.hawaiiframework.sql.SqlQueryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class BaseJdbcRepository {
    private static final String COULD_NOT_FIND_A_RESULT_FOR = "Could not find a result for '{}'.";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseJdbcRepository.class);
    private final SqlQueryResolver queryResolver;
    private final JdbcTemplate aJdbcTemplate;
    private final NamedParameterJdbcTemplate aNamedParameterJdbcTemplate;

    public BaseJdbcRepository(SqlQueryResolver queryResolver, DataSource dataSource) {
        this.queryResolver = queryResolver;
        this.aJdbcTemplate = new JdbcTemplate(dataSource);
        this.aNamedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    protected String resolveQuery(String sqlQueryName) {
        LOGGER.debug("Resolving query '{}'.", (Object)sqlQueryName);
        return this.queryResolver.resolveSqlQuery(sqlQueryName);
    }

    protected JdbcTemplate jdbcTemplate() {
        return this.aJdbcTemplate;
    }

    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate() {
        return this.aNamedParameterJdbcTemplate;
    }

    protected <T> T getOpt(String query, SqlParameterSource parameters, RowMapper<T> rowMapper) {
        try {
            return (T)this.aNamedParameterJdbcTemplate.queryForObject(this.resolveQuery(query), parameters, rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.debug(COULD_NOT_FIND_A_RESULT_FOR, (Object)query);
            return null;
        }
    }

    protected <T> T getOpt(String query, SqlParameterSource parameters, Class<T> requiredType) {
        try {
            return (T)this.aNamedParameterJdbcTemplate.queryForObject(this.resolveQuery(query), parameters, requiredType);
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.debug(COULD_NOT_FIND_A_RESULT_FOR, (Object)query);
            return null;
        }
    }

    protected <T> T getOpt(String query, SqlParameterSource parameters, ResultSetExtractor<T> extractor) {
        try {
            return (T)this.aNamedParameterJdbcTemplate.query(this.resolveQuery(query), parameters, extractor);
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.debug(COULD_NOT_FIND_A_RESULT_FOR, (Object)query);
            return null;
        }
    }

    protected <T> T get(String query, RowMapper<T> rowMapper) {
        return this.get(query, (SqlParameterSource)EmptySqlParameterSource.INSTANCE, rowMapper);
    }

    protected <T> T get(String query, SqlParameterSource parameters, RowMapper<T> rowMapper) {
        try {
            return (T)this.aNamedParameterJdbcTemplate.queryForObject(this.resolveQuery(query), parameters, rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.debug(COULD_NOT_FIND_A_RESULT_FOR, (Object)query);
            throw e;
        }
    }

    protected int update(String query, SqlParameterSource parameters) {
        try {
            return this.aNamedParameterJdbcTemplate.update(this.resolveQuery(query), parameters);
        }
        catch (DataAccessException e) {
            LOGGER.debug("Error performing '{}'.", (Object)query);
            throw e;
        }
    }

    protected <T> List<T> getList(String query, SqlParameterSource parameters, RowMapper<T> rowMapper) {
        try {
            return this.aNamedParameterJdbcTemplate.query(this.resolveQuery(query), parameters, rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.debug(COULD_NOT_FIND_A_RESULT_FOR, (Object)query);
            throw e;
        }
    }
}

