/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public final class ResultSetUtil {
    private ResultSetUtil() {
    }

    public static Integer getInteger(ResultSet resultSet, String columnLabel) throws SQLException {
        return ResultSetUtil.getValueOrNull(resultSet, resultSet.getInt(columnLabel));
    }

    public static Long getLong(ResultSet resultSet, String columnLabel) throws SQLException {
        return ResultSetUtil.getValueOrNull(resultSet, resultSet.getLong(columnLabel));
    }

    public static Date getDate(ResultSet resultSet, String columnLabel) throws SQLException {
        java.sql.Date sqlDate = ResultSetUtil.getValueOrNull(resultSet, resultSet.getDate(columnLabel));
        return ResultSetUtil.convert(sqlDate);
    }

    private static Date convert(java.sql.Date sqlDate) {
        if (sqlDate == null) {
            return null;
        }
        return new Date(sqlDate.getTime());
    }

    private static <T> T getValueOrNull(ResultSet resultSet, T value) throws SQLException {
        return resultSet.wasNull() ? null : (T)value;
    }
}

