/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.sql;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.hawaiiframework.exception.HawaiiException;
import org.hawaiiframework.sql.SqlQueryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCachingSqlQueryResolver
implements SqlQueryResolver {
    public static final int DEFAULT_CACHE_LIMIT = 1024;
    private static Logger logger = LoggerFactory.getLogger(AbstractCachingSqlQueryResolver.class);
    private final Map<Object, QueryHolder> sqlQueryAccessCache = new ConcurrentHashMap<Object, QueryHolder>(1024);
    private volatile int cacheLimit = 1024;
    private final Map<Object, QueryHolder> sqlQueryCreationCache = new LinkedHashMap<Object, QueryHolder>(1024, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, QueryHolder> eldest) {
            if (this.size() > AbstractCachingSqlQueryResolver.this.getCacheLimit()) {
                AbstractCachingSqlQueryResolver.this.sqlQueryAccessCache.remove(eldest.getKey());
                return true;
            }
            return false;
        }
    };
    private boolean cacheUnresolved = true;
    private long cacheMillis = -1L;

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public boolean isCache() {
        return this.cacheLimit > 0;
    }

    public void setCache(boolean cache) {
        this.cacheLimit = cache ? 1024 : 0;
    }

    public void setCacheUnresolved(boolean cacheUnresolved) {
        this.cacheUnresolved = cacheUnresolved;
    }

    protected Object getCacheKey(String sqlQueryName) {
        return sqlQueryName;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheMillis = 1000 * cacheSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String sqlQueryName) {
        if (!this.isCache()) {
            logger.warn("Sql query caching is SWITCHED OFF -- removal not necessary");
        } else {
            QueryHolder cachedSqlQuery;
            Object cacheKey = this.getCacheKey(sqlQueryName);
            Map<Object, QueryHolder> map = this.sqlQueryCreationCache;
            synchronized (map) {
                this.sqlQueryAccessCache.remove(cacheKey);
                cachedSqlQuery = this.sqlQueryCreationCache.remove(cacheKey);
            }
            if (logger.isDebugEnabled()) {
                if (cachedSqlQuery == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No cached instance for sql query '" + cacheKey + "' was found");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Cache for sql query " + cacheKey + " has been cleared");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        logger.debug("Clearing entire sql query cache");
        Map<Object, QueryHolder> map = this.sqlQueryCreationCache;
        synchronized (map) {
            this.sqlQueryAccessCache.clear();
            this.sqlQueryCreationCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolveSqlQuery(String sqlQueryName) throws HawaiiException {
        if (!this.isCache()) {
            return this.loadSqlQuery(sqlQueryName, null);
        }
        Object cacheKey = this.getCacheKey(sqlQueryName);
        QueryHolder queryHolder = this.sqlQueryAccessCache.get(cacheKey);
        if (queryHolder != null) {
            long originalTimestamp = queryHolder.getRefreshTimestamp();
            if (originalTimestamp > System.currentTimeMillis() - this.cacheMillis) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Query {} within cache seconds, not refreshing", (Object)sqlQueryName);
                }
                return queryHolder.getSqlQuery();
            }
            this.refreshQueryHolder(sqlQueryName, queryHolder);
        } else {
            Map<Object, QueryHolder> map = this.sqlQueryCreationCache;
            synchronized (map) {
                queryHolder = this.sqlQueryCreationCache.get(cacheKey);
                if (queryHolder == null) {
                    queryHolder = new QueryHolder();
                    queryHolder.setRefreshTimestamp(System.currentTimeMillis());
                    this.loadSqlQuery(sqlQueryName, queryHolder);
                    if (this.cacheUnresolved || queryHolder.getSqlQuery() != null) {
                        this.sqlQueryAccessCache.put(cacheKey, queryHolder);
                        this.sqlQueryCreationCache.put(cacheKey, queryHolder);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Cached sql query [" + cacheKey + "]");
                        }
                    }
                }
            }
        }
        return queryHolder.getSqlQuery();
    }

    private void refreshQueryHolder(String sqlQueryName, QueryHolder queryHolder) {
        if (logger.isTraceEnabled()) {
            logger.trace("Attempting to refresh QueryHolder for query {}", (Object)sqlQueryName);
        }
        if (!queryHolder.refreshLock.tryLock()) {
            if (logger.isTraceEnabled()) {
                logger.trace("QueryHolder is locked");
            }
            return;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Refreshing query");
            }
            this.doRefreshQueryHolder(sqlQueryName, queryHolder);
        }
        finally {
            queryHolder.refreshLock.unlock();
        }
    }

    protected void doRefreshQueryHolder(String sqlQueryName, QueryHolder queryHolder) {
    }

    protected abstract String loadSqlQuery(String var1, QueryHolder var2) throws HawaiiException;

    protected static class QueryHolder {
        private String sqlQuery;
        private volatile long refreshTimestamp = -2L;
        private long queryTimestamp = -1L;
        private final ReentrantLock refreshLock = new ReentrantLock();

        protected QueryHolder() {
        }

        public String getSqlQuery() {
            return this.sqlQuery;
        }

        public void setSqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
        }

        public long getRefreshTimestamp() {
            return this.refreshTimestamp;
        }

        public void setRefreshTimestamp(long refreshTimestamp) {
            this.refreshTimestamp = refreshTimestamp;
        }

        public long getQueryTimestamp() {
            return this.queryTimestamp;
        }

        public void setQueryTimestamp(long queryTimestamp) {
            this.queryTimestamp = queryTimestamp;
        }
    }
}

