/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.sql;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.ReflectionUtils;

public class DataSourceMethodInterceptor
implements MethodInterceptor {
    private final DataSource dataSource;

    public DataSourceMethodInterceptor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method proxyMethod = ReflectionUtils.findMethod(this.dataSource.getClass(), (String)invocation.getMethod().getName());
        if (proxyMethod != null) {
            return proxyMethod.invoke((Object)this.dataSource, invocation.getArguments());
        }
        return invocation.proceed();
    }
}

