/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.sql;

import javax.sql.DataSource;
import net.ttddyy.dsproxy.support.ProxyDataSource;
import org.aopalliance.aop.Advice;
import org.hawaiiframework.sql.DataSourceMethodInterceptor;
import org.hawaiiframework.sql.DataSourceProxyFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class DataSourceProxyBeanPostProcessor
implements BeanPostProcessor {
    private final DataSourceProxyFactory dataSourceProxyFactory;

    public DataSourceProxyBeanPostProcessor(DataSourceProxyFactory dataSourceProxyFactory) {
        this.dataSourceProxyFactory = dataSourceProxyFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String ignored) {
        return this.createDataSourceProxy(bean);
    }

    private Object createDataSourceProxy(Object bean) {
        if (!(bean instanceof DataSource) || bean instanceof ProxyDataSource) {
            return bean;
        }
        DataSource proxyDataSource = this.dataSourceProxyFactory.proxy((DataSource)bean);
        ProxyFactory factory = new ProxyFactory(bean);
        factory.setProxyTargetClass(true);
        factory.addAdvice((Advice)new DataSourceMethodInterceptor(proxyDataSource));
        return factory.getProxy();
    }
}

