/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.sql;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.hawaiiframework.exception.HawaiiException;
import org.hawaiiframework.sql.AbstractCachingSqlQueryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ResourceSqlQueryResolver
extends AbstractCachingSqlQueryResolver
implements Ordered {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static Logger logger = LoggerFactory.getLogger(ResourceSqlQueryResolver.class);
    private final ResourceLoader resourceLoader;
    private Charset charset = DEFAULT_CHARSET;
    private String prefix = "";
    private String suffix = "";
    private int order = Integer.MAX_VALUE;

    public ResourceSqlQueryResolver() {
        this((ResourceLoader)new DefaultResourceLoader());
    }

    public ResourceSqlQueryResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    protected void doRefreshQueryHolder(String sqlQueryName, AbstractCachingSqlQueryResolver.QueryHolder queryHolder) {
        String location = this.getPrefix() + sqlQueryName + this.getSuffix();
        Resource resource = this.resourceLoader.getResource(location);
        if (resource.exists() && resource.getFilename() != null) {
            long checkpoint = queryHolder.getQueryTimestamp();
            try {
                long lastModified = resource.lastModified();
                if (lastModified > checkpoint) {
                    this.loadSqlQuery(sqlQueryName, queryHolder);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Query file {} unchanged - not reloading", (Object)resource.getFilename());
                }
            }
            catch (IOException e) {
                throw new HawaiiException(String.format("Error accessing '%s'", resource.getFilename()), e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String loadSqlQuery(String sqlQueryName, AbstractCachingSqlQueryResolver.QueryHolder queryHolder) throws HawaiiException {
        String location = this.getPrefix() + sqlQueryName + this.getSuffix();
        Resource resource = this.resourceLoader.getResource(location);
        String query = null;
        if (resource.exists()) {
            try {
                query = new Scanner(resource.getInputStream(), this.charset.name()).useDelimiter("\\Z").next();
                if (queryHolder == null || resource.getFilename() == null) return query;
                if (logger.isTraceEnabled()) {
                    logger.trace("Updating query {}", (Object)resource.getFilename());
                }
                queryHolder.setSqlQuery(query);
                queryHolder.setRefreshTimestamp(System.currentTimeMillis());
                queryHolder.setQueryTimestamp(resource.lastModified());
                return query;
            }
            catch (IOException e) {
                throw new HawaiiException("Error reading resource: " + location, e);
            }
        } else {
            if (!logger.isDebugEnabled()) return query;
            logger.debug("Resource {} does not exist", (Object)resource.getDescription());
        }
        return query;
    }
}

