/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawaiiframework.exception.HawaiiException;
import org.hawaiiframework.sql.SqlQueryResolver;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class SqlQueryResolverComposite
implements SqlQueryResolver,
Ordered {
    private final List<SqlQueryResolver> sqlQueryResolvers = new ArrayList<SqlQueryResolver>();
    private int order = Integer.MAX_VALUE;

    public List<SqlQueryResolver> getSqlQueryResolvers() {
        return Collections.unmodifiableList(this.sqlQueryResolvers);
    }

    public void setSqlQueryResolvers(List<SqlQueryResolver> sqlQueryResolvers) {
        this.sqlQueryResolvers.clear();
        if (!CollectionUtils.isEmpty(sqlQueryResolvers)) {
            this.sqlQueryResolvers.addAll(sqlQueryResolvers);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public String resolveSqlQuery(String sqlQueryName) throws HawaiiException {
        for (SqlQueryResolver sqlQueryResolver : this.sqlQueryResolvers) {
            String sqlQuery = sqlQueryResolver.resolveSqlQuery(sqlQueryName);
            if (sqlQuery == null) continue;
            return sqlQuery;
        }
        return null;
    }
}

