/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.hawaiiframework.time.HawaiiZonedClock;

public class HawaiiTime {
    protected static final ZoneId DEFAULT_ZONE = ZoneOffset.UTC;
    private static final String CLOCK_MUST_NOT_BE_NULL = "'clock' must not be null";
    private static final String DATETIME_MUST_NOT_BE_NULL = "'dateTime' must not be null";
    private static final String INSTANT_MUST_NOT_BE_NULL = "'instant' must not be null";
    private static final String ZONE_MUST_NOT_BE_NULL = "'zone' must not be null";
    private static final HawaiiZonedClock INSTANCE = new HawaiiZonedClock();

    public HawaiiTime() {
        this(DEFAULT_ZONE);
    }

    public HawaiiTime(ZoneId zone) {
        this(Clock.system(Objects.requireNonNull(zone, ZONE_MUST_NOT_BE_NULL)));
    }

    public HawaiiTime(Clock clock) {
        INSTANCE.setClock(Objects.requireNonNull(clock, CLOCK_MUST_NOT_BE_NULL));
        INSTANCE.setZone(clock.getZone());
        INSTANCE.setHawaiiTime(this);
    }

    public static HawaiiTime getInstance() {
        return INSTANCE.getHawaiiTime();
    }

    public Clock getClock() {
        return INSTANCE.getClock();
    }

    public void setClock(Clock clock) {
        INSTANCE.setClock(Objects.requireNonNull(clock, CLOCK_MUST_NOT_BE_NULL));
    }

    public ZoneId getZone() {
        return INSTANCE.getZone();
    }

    public void setZone(ZoneId zone) {
        INSTANCE.setZone(zone);
    }

    public Long between(Instant time) {
        return Duration.between(this.instant(), time).toMillis();
    }

    public void useFixedClock(Clock clock) {
        Objects.requireNonNull(clock, CLOCK_MUST_NOT_BE_NULL);
        this.useFixedClock(clock.instant(), clock.getZone());
    }

    public void useFixedClock(long millis) {
        this.useFixedClock(Instant.ofEpochMilli(millis), this.getZone());
    }

    public void useFixedClock(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime, DATETIME_MUST_NOT_BE_NULL);
        this.useFixedClock(dateTime.atZone(this.getZone()).toInstant(), this.getZone());
    }

    public void useFixedClock(OffsetDateTime dateTime) {
        Objects.requireNonNull(dateTime, DATETIME_MUST_NOT_BE_NULL);
        this.useFixedClock(dateTime.toInstant(), dateTime.getOffset());
    }

    public void useFixedClock(ZonedDateTime dateTime) {
        Objects.requireNonNull(dateTime, DATETIME_MUST_NOT_BE_NULL);
        this.useFixedClock(dateTime.toInstant(), dateTime.getZone());
    }

    protected void useFixedClock(Instant instant) {
        Objects.requireNonNull(instant, INSTANT_MUST_NOT_BE_NULL);
        this.setClock(Clock.fixed(instant, this.getZone()));
    }

    protected void useFixedClock(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, INSTANT_MUST_NOT_BE_NULL);
        Objects.requireNonNull(zone, ZONE_MUST_NOT_BE_NULL);
        this.setClock(Clock.fixed(instant, zone));
    }

    public void useSystemClock() {
        this.setClock(Clock.system(this.getZone()));
    }

    public Instant instant() {
        return Instant.now(this.getClock());
    }

    public LocalDate localDate() {
        return LocalDate.now(this.getClock());
    }

    public LocalDateTime localDateTime() {
        return LocalDateTime.now(this.getClock());
    }

    public LocalTime localTime() {
        return LocalTime.now(this.getClock());
    }

    public long millis() {
        return this.getClock().millis();
    }

    public MonthDay monthDay() {
        return MonthDay.now(this.getClock());
    }

    public OffsetDateTime offsetDateTime() {
        return OffsetDateTime.now(this.getClock());
    }

    public OffsetTime offsetTime() {
        return OffsetTime.now(this.getClock());
    }

    public Year year() {
        return Year.now(this.getClock());
    }

    public YearMonth yearMonth() {
        return YearMonth.now(this.getClock());
    }

    public ZonedDateTime zonedDateTime() {
        return ZonedDateTime.now(this.getClock());
    }
}

