/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.Validation;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.hawaiiframework.validation.ValidationResult;
import org.hawaiiframework.validation.Validator;
import org.hibernate.validator.internal.engine.ValidatorFactoryImpl;

public class JakartaValidationValidator<T>
implements Validator<T> {
    @Override
    public void validate(T object, ValidationResult validationResult) {
        HashSet<String> requiredFields = new HashSet<String>();
        HashSet<String> invalidFields = new HashSet<String>();
        try (ValidatorFactoryImpl factory = (ValidatorFactoryImpl)Validation.buildDefaultValidatorFactory();){
            jakarta.validation.Validator validator = factory.getValidator();
            Set violations = validator.validate(object, new Class[0]);
            for (ConstraintViolation constraintViolation : violations) {
                Path path = constraintViolation.getPropertyPath();
                String propertyPath = path.toString();
                Annotation annotation = constraintViolation.getConstraintDescriptor().getAnnotation();
                Class<? extends Annotation> annotationType = annotation.annotationType();
                boolean required = this.isRequired(annotationType);
                if (required) {
                    invalidFields.remove(propertyPath);
                    requiredFields.add(propertyPath);
                    continue;
                }
                if (requiredFields.contains(propertyPath)) continue;
                invalidFields.add(propertyPath);
            }
            for (String path : requiredFields) {
                validationResult.rejectValue(path, "REQUIRED");
            }
            for (String path : invalidFields) {
                validationResult.rejectValue(path, "INVALID");
            }
        }
    }

    private boolean isRequired(Class<? extends Annotation> annotationType) {
        return annotationType.isAssignableFrom(NotBlank.class) || annotationType.isAssignableFrom(NotEmpty.class) || annotationType.isAssignableFrom(NotNull.class);
    }
}

