/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.validation;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hamcrest.Matcher;
import org.hawaiiframework.validation.ValidationError;
import org.hawaiiframework.validation.field.FieldRejection;

public class ValidationResult
implements Serializable {
    private static final long serialVersionUID = 6587801940281589895L;
    private static final String NESTED_PATH_SEPARATOR = ".";
    private static final String NESTED_PATH_INDEX_PREFIX = "[";
    private static final String NESTED_PATH_INDEX_SUFFIX = "]";
    private final transient Deque<String> nestedPathStack = new ArrayDeque<String>();
    private final transient List<ValidationError> errors = new LinkedList<ValidationError>();

    public String getNestedPath() {
        String nestedPath = this.nestedPathStack.peek();
        return StringUtils.defaultString((String)nestedPath);
    }

    public void pushNestedPath(String path) {
        this.doPushNestedPath(path, null);
    }

    public void pushNestedPath(String path, int index) {
        this.doPushNestedPath(path, index);
    }

    private void doPushNestedPath(String path, Integer index) {
        StringBuilder nestedPathBuilder = new StringBuilder(this.getNestedPath());
        if (nestedPathBuilder.length() > 0) {
            nestedPathBuilder.append(NESTED_PATH_SEPARATOR);
        }
        nestedPathBuilder.append(path);
        if (index != null) {
            nestedPathBuilder.append(NESTED_PATH_INDEX_PREFIX);
            nestedPathBuilder.append(index);
            nestedPathBuilder.append(NESTED_PATH_INDEX_SUFFIX);
        }
        this.nestedPathStack.push(nestedPathBuilder.toString());
    }

    public void popNestedPath() throws IllegalArgumentException {
        try {
            this.nestedPathStack.pop();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Cannot pop nested path: no nested path on stack", e);
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<ValidationError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void reject(String code) {
        this.addError(new ValidationError(code));
    }

    public void rejectIf(boolean expr, String code) {
        if (expr) {
            this.reject(code);
        }
    }

    public <T> void rejectIf(T actual, Matcher<? super T> matcher, String code) {
        this.rejectIf(matcher.matches(actual), code);
    }

    public void rejectValue(String code) {
        this.rejectValue(null, code);
    }

    public void rejectValue(String field, String code) {
        StringBuilder fieldBuilder = new StringBuilder(this.getNestedPath());
        if (StringUtils.isNotBlank((CharSequence)field)) {
            if (fieldBuilder.length() > 0) {
                fieldBuilder.append(NESTED_PATH_SEPARATOR);
            }
            fieldBuilder.append(field);
        }
        if (fieldBuilder.length() == 0) {
            this.reject(code);
        } else {
            this.addError(new ValidationError(fieldBuilder.toString(), code));
        }
    }

    public void rejectValueIf(boolean expr, String code) {
        if (expr) {
            this.rejectValue(code);
        }
    }

    public <T> void rejectValueIf(T actual, Matcher<? super T> matcher, String code) {
        this.rejectValueIf(matcher.matches(actual), code);
    }

    public void rejectValueIf(boolean expr, String field, String code) {
        if (expr) {
            this.rejectValue(field, code);
        }
    }

    public <T> void rejectValueIf(T actual, Matcher<? super T> matcher, String field, String code) {
        this.rejectValueIf(matcher.matches(actual), field, code);
    }

    public <T> FieldRejection<T> rejectField(String field, T actual) {
        return new FieldRejection<T>(this, field, actual);
    }

    public void addError(ValidationError error) {
        this.errors.add(error);
    }

    public void addAllErrors(List<ValidationError> errors) {
        this.errors.addAll(errors);
    }

    public void addAllErrors(ValidationResult validationResult) {
        this.errors.addAll(validationResult.getErrors());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

